/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlSignal;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;
import org.wso2.transport.http.netty.contractimpl.HttpWsServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketBinaryMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketCloseMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketControlMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketTextMessageImpl;
import org.wso2.transport.http.netty.exception.UnknownWebSocketFrameTypeException;
import org.wso2.transport.http.netty.internal.websocket.WebSocketSessionImpl;
import org.wso2.transport.http.netty.listener.SourceHandler;

public class WebSocketSourceHandler
extends SourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSourceHandler.class);
    private final String target;
    private final ChannelHandlerContext ctx;
    private final boolean isSecured;
    private final ServerConnectorFuture connectorFuture;
    private final WebSocketSessionImpl channelSession;
    private final Map<String, String> headers;
    private final String interfaceId;
    private String subProtocol = null;

    public WebSocketSourceHandler(ServerConnectorFuture connectorFuture, boolean isSecured, WebSocketSessionImpl channelSession, HttpRequest httpRequest, Map<String, String> headers, ChannelHandlerContext ctx, String interfaceId) throws Exception {
        super(new HttpWsServerConnectorFuture(), interfaceId);
        this.connectorFuture = connectorFuture;
        this.isSecured = isSecured;
        this.channelSession = channelSession;
        this.ctx = ctx;
        this.interfaceId = interfaceId;
        this.target = httpRequest.uri();
        this.headers = headers;
    }

    public WebSocketSessionImpl getChannelSession() {
        return this.channelSession;
    }

    public void setNegotiatedSubProtocol(String negotiatedSubProtocol) {
        this.subProtocol = negotiatedSubProtocol;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent idleStateEvent;
        if (evt instanceof IdleStateEvent && (idleStateEvent = (IdleStateEvent)evt).state() == IdleStateEvent.ALL_IDLE_STATE_EVENT.state()) {
            this.notifyIdleTimeout();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.channelSession.isOpen()) {
            this.channelSession.setIsOpen(false);
            int statusCode = 1001;
            String reasonText = "Client is going away";
            this.notifyCloseMessage(statusCode, reasonText);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws UnknownWebSocketFrameTypeException, ServerConnectorException {
        if (!(msg instanceof WebSocketFrame)) {
            logger.error("Expecting WebSocketFrame. Unknown type.");
            throw new UnknownWebSocketFrameTypeException("Expecting WebSocketFrame. Unknown type.");
        }
        if (msg instanceof TextWebSocketFrame) {
            this.notifyTextMessage((TextWebSocketFrame)msg);
        } else if (msg instanceof BinaryWebSocketFrame) {
            this.notifyBinaryMessage((BinaryWebSocketFrame)msg);
        } else if (msg instanceof CloseWebSocketFrame) {
            this.notifyCloseMessage((CloseWebSocketFrame)msg);
        } else if (msg instanceof PingWebSocketFrame) {
            this.notifyPingMessage((PingWebSocketFrame)msg);
        } else if (msg instanceof PongWebSocketFrame) {
            this.notifyPongMessage((PongWebSocketFrame)msg);
        }
    }

    private void notifyTextMessage(TextWebSocketFrame textWebSocketFrame) throws ServerConnectorException {
        String text = textWebSocketFrame.text();
        boolean isFinalFragment = textWebSocketFrame.isFinalFragment();
        WebSocketMessageImpl webSocketTextMessage = new WebSocketTextMessageImpl(text, isFinalFragment);
        webSocketTextMessage = this.setupCommonProperties(webSocketTextMessage);
        this.connectorFuture.notifyWSListener((WebSocketTextMessage)((Object)webSocketTextMessage));
    }

    private void notifyBinaryMessage(BinaryWebSocketFrame binaryWebSocketFrame) throws ServerConnectorException {
        ByteBuf byteBuf = binaryWebSocketFrame.content();
        boolean finalFragment = binaryWebSocketFrame.isFinalFragment();
        ByteBuffer byteBuffer = byteBuf.nioBuffer();
        WebSocketMessageImpl webSocketBinaryMessage = new WebSocketBinaryMessageImpl(byteBuffer, finalFragment);
        webSocketBinaryMessage = this.setupCommonProperties(webSocketBinaryMessage);
        this.connectorFuture.notifyWSListener((WebSocketBinaryMessage)((Object)webSocketBinaryMessage));
    }

    private void notifyCloseMessage(CloseWebSocketFrame closeWebSocketFrame) throws ServerConnectorException {
        String reasonText = closeWebSocketFrame.reasonText();
        int statusCode = closeWebSocketFrame.statusCode();
        this.ctx.channel().close();
        this.channelSession.setIsOpen(false);
        WebSocketMessageImpl webSocketCloseMessage = new WebSocketCloseMessageImpl(statusCode, reasonText);
        webSocketCloseMessage = this.setupCommonProperties(webSocketCloseMessage);
        this.connectorFuture.notifyWSListener((WebSocketCloseMessage)((Object)webSocketCloseMessage));
    }

    private void notifyCloseMessage(int statusCode, String reasonText) throws ServerConnectorException {
        this.ctx.channel().close();
        this.channelSession.setIsOpen(false);
        WebSocketMessageImpl webSocketCloseMessage = new WebSocketCloseMessageImpl(statusCode, reasonText);
        webSocketCloseMessage = this.setupCommonProperties(webSocketCloseMessage);
        this.connectorFuture.notifyWSListener((WebSocketCloseMessage)((Object)webSocketCloseMessage));
    }

    private void notifyPingMessage(PingWebSocketFrame pingWebSocketFrame) throws ServerConnectorException {
        ByteBuf byteBuf = pingWebSocketFrame.content();
        ByteBuffer byteBuffer = byteBuf.nioBuffer();
        WebSocketMessageImpl webSocketControlMessage = new WebSocketControlMessageImpl(WebSocketControlSignal.PING, byteBuffer);
        webSocketControlMessage = this.setupCommonProperties(webSocketControlMessage);
        this.connectorFuture.notifyWSListener((WebSocketControlMessage)((Object)webSocketControlMessage));
    }

    private void notifyPongMessage(PongWebSocketFrame pongWebSocketFrame) throws ServerConnectorException {
        ByteBuf byteBuf = pongWebSocketFrame.content();
        ByteBuffer byteBuffer = byteBuf.nioBuffer();
        WebSocketMessageImpl webSocketControlMessage = new WebSocketControlMessageImpl(WebSocketControlSignal.PONG, byteBuffer);
        webSocketControlMessage = this.setupCommonProperties(webSocketControlMessage);
        this.connectorFuture.notifyWSListener((WebSocketControlMessage)((Object)webSocketControlMessage));
    }

    private void notifyIdleTimeout() throws ServerConnectorException {
        WebSocketMessageImpl websocketControlMessage = new WebSocketControlMessageImpl(WebSocketControlSignal.IDLE_TIMEOUT, null);
        websocketControlMessage = this.setupCommonProperties(websocketControlMessage);
        this.connectorFuture.notifyWSIdleTimeout((WebSocketControlMessage)((Object)websocketControlMessage));
    }

    private WebSocketMessageImpl setupCommonProperties(WebSocketMessageImpl webSocketMessage) {
        webSocketMessage.setSubProtocol(this.subProtocol);
        webSocketMessage.setTarget(this.target);
        webSocketMessage.setListenerInterface(this.interfaceId);
        webSocketMessage.setIsConnectionSecured(this.isSecured);
        webSocketMessage.setIsServerMessage(true);
        webSocketMessage.setChannelSession(this.channelSession);
        webSocketMessage.setHeaders(this.headers);
        webSocketMessage.setSessionlID(this.channelSession.getId());
        webSocketMessage.setProperty("SRC_HANDLER", (Object)this);
        webSocketMessage.setProperty("LISTENER_PORT", ((InetSocketAddress)this.ctx.channel().localAddress()).getPort());
        webSocketMessage.setProperty("LOCAL_ADDRESS", this.ctx.channel().localAddress());
        webSocketMessage.setProperty("LOCAL_NAME", ((InetSocketAddress)this.ctx.channel().localAddress()).getHostName());
        return webSocketMessage;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().writeAndFlush((Object)new CloseWebSocketFrame(1011, "Encountered an unexpected condition"));
        ctx.close();
        this.connectorFuture.notifyWSListener(cause);
    }
}

