/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.List;

public class CustomHttpContentCompressor
extends HttpContentCompressor {
    private HttpMethod method;
    private boolean chunkDisabled = false;

    public CustomHttpContentCompressor() {
    }

    public CustomHttpContentCompressor(boolean chunkDisabled) {
        this.chunkDisabled = chunkDisabled;
    }

    protected HttpContentEncoder.Result beginEncode(HttpResponse headers, String acceptEncoding) throws Exception {
        if (this.chunkDisabled) {
            return null;
        }
        String allowHeader = headers.headers().get("Allow");
        String contentLength = headers.headers().get("Content-Length");
        if (this.method == HttpMethod.OPTIONS && allowHeader != null && contentLength.equals("0")) {
            return null;
        }
        return super.beginEncode(headers, acceptEncoding);
    }

    protected void decode(ChannelHandlerContext ctx, HttpRequest msg, List<Object> out) throws Exception {
        this.method = msg.method();
        super.decode(ctx, msg, out);
    }
}

