/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.internal.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;

public class WebSocketBasicRemoteEndpoint
implements RemoteEndpoint.Basic {
    private final ChannelHandlerContext ctx;

    public WebSocketBasicRemoteEndpoint(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public void sendText(String text) throws IOException {
        this.ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(text));
    }

    public void sendBinary(ByteBuffer data) throws IOException {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)data);
        this.ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf));
    }

    public void sendText(String partialMessage, boolean isLast) throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
        ByteBuf partialByteBuf = Unpooled.wrappedBuffer((ByteBuffer)partialByte);
        this.ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(isLast, 0, partialByteBuf));
    }

    public OutputStream getSendStream() throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Writer getSendWriter() throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public void sendObject(Object data) throws IOException, EncodeException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public void setBatchingAllowed(boolean allowed) throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public boolean getBatchingAllowed() {
        return false;
    }

    public void flushBatch() throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        ByteBuf applicationDataBuf = Unpooled.wrappedBuffer((ByteBuffer)applicationData);
        this.ctx.channel().writeAndFlush((Object)new PingWebSocketFrame(applicationDataBuf));
    }

    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        ByteBuf applicationDataBuf = Unpooled.wrappedBuffer((ByteBuffer)applicationData);
        this.ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(applicationDataBuf));
    }
}

