/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.client.codec;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import feign.FeignException;
import feign.Response;
import feign.jackson.JacksonDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;

public class MSF4JJacksonDecoder
extends JacksonDecoder {
    private final ObjectMapper mapper;

    public MSF4JJacksonDecoder() {
        this(Collections.emptyList());
    }

    public MSF4JJacksonDecoder(Iterable<Module> modules) {
        this(new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModules(modules));
    }

    public MSF4JJacksonDecoder(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        if (response.body() == null) {
            return null;
        }
        Reader reader = response.body().asReader();
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader, 1);
        }
        try {
            reader.mark(1);
            if (reader.read() == -1) {
                return null;
            }
            reader.reset();
            return this.mapper.readValue(reader, this.mapper.constructType(type));
        }
        catch (RuntimeJsonMappingException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof IOException) {
                throw (IOException)IOException.class.cast(cause);
            }
            throw e;
        }
    }
}

