/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.client.codec;

import feign.FeignException;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.StringDecoder;
import feign.gson.GsonDecoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

public class MSF4JDecoder
implements Decoder {
    private GsonDecoder gsonDecoder = new GsonDecoder();
    private StringDecoder stringDecoder = new StringDecoder();
    private static final String CONTENT_TYPE = "Content-Type";

    public Object decode(Response response, Type type) throws IOException, FeignException {
        String responseContentType;
        Collection contentTypeHeaders = (Collection)response.headers().get(CONTENT_TYPE);
        String string = responseContentType = contentTypeHeaders != null ? (String)contentTypeHeaders.iterator().next() : "text/plain";
        if (responseContentType.equals("application/json")) {
            return this.gsonDecoder.decode(response, type);
        }
        if (responseContentType.equals("text/plain") || responseContentType.equals("*/*")) {
            return this.stringDecoder.decode(response, type);
        }
        throw new RuntimeException("Unsupported Content Type " + responseContentType);
    }
}

