/*
 * Decompiled with CFR 0.152.
 */
package samples.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import samples.util.SampleAxis2ServerManager;

public class SampleAxis2Server {
    private static final Log log = LogFactory.getLog(SampleAxis2Server.class);

    public static void main(String[] args) throws Exception {
        if (System.getProperty("carbon.components.dir.path") != null) {
            SampleAxis2Server.addJarFileUrls(new File(System.getProperty("carbon.components.dir.path")));
        }
        SampleAxis2Server.startServer(args);
        SampleAxis2Server.addShutdownHook();
    }

    private static void addShutdownHook() {
        Thread shutdownHook = new Thread(){

            @Override
            public void run() {
                log.info((Object)"Shutting down SimpleAxisServer ...");
                try {
                    SampleAxis2Server.stopServer();
                    log.info((Object)"Shutdown complete");
                    log.info((Object)"Halting JVM");
                }
                catch (Exception e) {
                    log.warn((Object)("Error occurred while shutting down SimpleAxisServer : " + e));
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static void startServer(String[] args) throws Exception {
        SampleAxis2ServerManager.getInstance().start(args);
    }

    public static void stopServer() throws Exception {
        SampleAxis2ServerManager.getInstance().stop();
    }

    private static void addJarFileUrls(File root) throws Exception {
        File[] children = root.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!child.isFile() || !child.canRead() || !child.getName().toLowerCase().endsWith(".jar") || child.getName().toLowerCase().startsWith("org.apache.synapse.module") || child.getName().toLowerCase().startsWith("wss4j") || child.getName().contains("slf4j")) continue;
            SampleAxis2Server.addPath(child.getPath());
        }
    }

    private static void addPath(String s) throws Exception {
        File f = new File(s);
        URL u = f.toURL();
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u);
    }
}

