/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;

public class ServiceInvoker
extends Thread {
    private String invokerName = "anonymous";
    private String operation = null;
    private ServiceClient client = null;
    private OMElement msg = null;
    private long iterations = 10L;
    private boolean statefull = false;
    private OMFactory fac = null;
    private long runningTime = 0L;

    public ServiceInvoker(String epr, String operation) {
        this.operation = operation;
        Options options = new Options();
        options.setTo(new EndpointReference(epr));
        options.setAction(operation);
        try {
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)"client_repo", null);
            this.client = new ServiceClient(configContext, null);
            options.setTimeOutInMilliSeconds(10000000L);
            this.client.setOptions(options);
            this.client.engageModule("addressing");
        }
        catch (AxisFault axisFault) {
            axisFault.printStackTrace();
        }
        this.fac = OMAbstractFactory.getOMFactory();
        this.msg = this.fac.createOMElement("SampleMsg", null);
        OMElement load = this.fac.createOMElement("load", null);
        load.setText("1000");
        this.msg.addChild((OMNode)load);
    }

    public String getInvokerName() {
        return this.invokerName;
    }

    public void setInvokerName(String invokerName) {
        this.invokerName = invokerName;
        if (this.statefull) {
            this.client.getOptions().setManageSession(true);
            this.client.getOptions().setAction("setClientName");
            OMElement cName = this.fac.createOMElement("cName", null);
            cName.setText(invokerName);
            try {
                OMElement response = this.client.sendReceive(cName);
                System.out.println(response.getText());
            }
            catch (AxisFault axisFault) {
                axisFault.printStackTrace();
            }
        }
    }

    public long getRunningTime() {
        return this.runningTime;
    }

    public void setLoad(String load) {
        OMElement loadElement = this.msg.getFirstChildWithName(new QName("load"));
        loadElement.setText(load);
    }

    public void addDummyElements(long numElements) {
        OMElement dummies = this.fac.createOMElement("Dummies", null);
        this.msg.addChild((OMNode)dummies);
        for (long i = 0L; i < numElements; ++i) {
            OMElement dummy = this.fac.createOMElement("Dummy", null);
            dummy.setText("This is the dummy element " + i);
            dummies.addChild((OMNode)dummy);
        }
    }

    public void setClientSessionID(String id) {
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP12Factory();
        OMNamespace synNamespace = soapFactory.createOMNamespace("http://ws.apache.org/namespaces/synapse", "syn");
        SOAPHeaderBlock header = soapFactory.createSOAPHeaderBlock("ClientID", synNamespace);
        header.setText(id);
        this.client.addHeader(header);
    }

    public void setIterations(long i) {
        this.iterations = i;
    }

    public void setStatefull(boolean state) {
        this.statefull = state;
    }

    public void run() {
        this.client.getOptions().setAction(this.operation);
        try {
            long t1 = System.currentTimeMillis();
            for (long i = 0L; i < this.iterations; ++i) {
                OMElement response2 = this.client.sendReceive(this.msg);
                OMElement loadElement = response2.getFirstChildWithName(new QName("load"));
                System.out.println(this.invokerName + ": " + loadElement.toString());
            }
            long t2 = System.currentTimeMillis();
            System.out.println("================================================================");
            System.out.println(this.invokerName + " completed requests.");
            System.out.println("================================================================");
            this.runningTime = t2 - t1;
        }
        catch (AxisFault axisFault) {
            System.out.println(axisFault.getMessage());
        }
    }
}

