/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.dataservice.integration.ui.pages.login;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.ei.dataservice.integration.ui.pages.UIElementMapper;
import org.wso2.ei.dataservice.integration.ui.pages.home.HomePage;

public class LoginPage {
    private static final Log log = LogFactory.getLog(LoginPage.class);
    private WebDriver driver;
    private UIElementMapper uiElementMapper;

    public LoginPage(WebDriver driver) throws IOException {
        this.driver = driver;
        this.uiElementMapper = UIElementMapper.getInstance();
        if (!driver.getCurrentUrl().contains("login.jsp")) {
            throw new IllegalStateException("This is not the login page");
        }
    }

    public HomePage loginAs(String userName, String password) throws IOException {
        log.info((Object)("Login as " + userName));
        WebElement userNameField = this.driver.findElement(By.name((String)this.uiElementMapper.getElement("login.username")));
        WebElement passwordField = this.driver.findElement(By.name((String)this.uiElementMapper.getElement("login.password")));
        userNameField.sendKeys(new CharSequence[]{userName});
        passwordField.sendKeys(new CharSequence[]{password});
        this.driver.findElement(By.className((String)this.uiElementMapper.getElement("login.sign.in.button"))).click();
        return new HomePage(this.driver);
    }
}

