/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients.stockquoteclient;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.esb.integration.common.utils.clients.axis2client.ConfigurationContextProvider;

public class StockQuoteClient {
    private static final Log log = LogFactory.getLog(StockQuoteClient.class);
    private List<Header> httpHeaders = new ArrayList<Header>();

    public void addHttpHeader(String name, String value) {
        this.httpHeaders.add(new Header(name, value));
    }

    public void clearHttpHeader() {
        this.httpHeaders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendSimpleStockQuoteRequest(String trpUrl, String addUrl, String symbol) throws AxisFault {
        ServiceClient sc = this.getServiceClient(trpUrl, addUrl);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(sc.sendReceive(this.createStandardRequest(symbol)));
            return oMElement;
        }
        finally {
            sc.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendSimpleStockQuoteRequestREST(String trpUrl, String addUrl, String symbol) throws AxisFault {
        ServiceClient sc = this.getRESTEnabledServiceClient(trpUrl, addUrl);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(sc.sendReceive(this.createStandardRequest(symbol)));
            return oMElement;
        }
        finally {
            sc.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendSimpleQuoteRequest(String trpUrl, String addUrl, String symbol) throws AxisFault {
        ServiceClient sc = this.getServiceClient(trpUrl, addUrl, "getSimpleQuote");
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(sc.sendReceive(this.createStandardSimpleRequest(symbol)));
            return oMElement;
        }
        finally {
            sc.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendSimpleQuoteRequestREST(String trpUrl, String addUrl, String symbol) throws AxisFault {
        ServiceClient serviceClient = this.getRESTEnabledServiceClient(trpUrl, addUrl, "getSimpleQuote");
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(this.createStandardSimpleRequest(symbol)));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendSimpleStockQuoteSoap11(String trpUrl, String addUrl, String symbol) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl);
        serviceClient.getOptions().setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(this.createStandardRequest(symbol)));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendSimpleStockQuoteSoap12(String trpUrl, String addUrl, String symbol) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl);
        serviceClient.getOptions().setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(this.createStandardRequest(symbol)));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendSimpleStockQuoteRequest(String trpUrl, String addUrl, OMElement payload) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(payload));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendSimpleStockQuoteRequestREST(String trpUrl, String addUrl, OMElement payload) throws AxisFault {
        ServiceClient serviceClient = this.getRESTEnabledServiceClient(trpUrl, addUrl);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(payload));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendCustomQuoteRequest(String trpUrl, String addUrl, String symbol) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(this.createCustomQuoteRequest(symbol)));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement send(String trpUrl, String addUrl, String action, OMElement payload) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl, action);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(payload));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRobust(String trpUrl, String addUrl, String action, OMElement payload) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl, action);
        try {
            serviceClient.sendRobust(payload);
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendCustomQuoteRequestREST(String trpUrl, String addUrl, String symbol) throws AxisFault {
        ServiceClient serviceClient = this.getRESTEnabledServiceClient(trpUrl, addUrl);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(this.createCustomQuoteRequest(symbol)));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendMultipleCustomQuoteRequest(String trpUrl, String addUrl, String symbol, int n) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(this.createMultipleCustomQuoteRequest(symbol, n)));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendMultipleQuoteRequest(String trpUrl, String addUrl, String symbol, int n) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(this.createMultipleQuoteRequest(symbol, n)));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendMultipleQuoteRequestREST(String trpUrl, String addUrl, String symbol, int n) throws AxisFault {
        ServiceClient serviceClient = this.getRESTEnabledServiceClient(trpUrl, addUrl);
        try {
            OMElement oMElement = StockQuoteClient.buildResponse(serviceClient.sendReceive(this.createMultipleQuoteRequest(symbol, n)));
            return oMElement;
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    private ServiceClient getServiceClient(String trpUrl, String addUrl) throws AxisFault {
        return this.getServiceClient(trpUrl, addUrl, "getQuote");
    }

    private ServiceClient getRESTEnabledServiceClient(String trpUrl, String addUrl) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl);
        serviceClient.getOptions().setProperty("enableREST", (Object)"true");
        return serviceClient;
    }

    private ServiceClient getServiceClient(String trpUrl, String addUrl, String operation) throws AxisFault {
        ServiceClient serviceClient;
        Options options = new Options();
        if (addUrl != null && !"null".equals(addUrl)) {
            serviceClient = new ServiceClient(ConfigurationContextProvider.getInstance().getConfigurationContext(), null);
            serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
        } else {
            serviceClient = new ServiceClient();
        }
        if (trpUrl != null && !"null".equals(trpUrl)) {
            options.setProperty("TransportURL", (Object)trpUrl);
        }
        options.setAction("urn:" + operation);
        if (this.httpHeaders.size() > 0) {
            options.setProperty("HTTP_HEADERS", this.httpHeaders);
        }
        options.setTimeOutInMilliSeconds(45000L);
        serviceClient.setOptions(options);
        return serviceClient;
    }

    private ServiceClient getRESTEnabledServiceClient(String trpUrl, String addUrl, String operation) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl, operation);
        serviceClient.getOptions().setProperty("enableREST", (Object)"true");
        return serviceClient;
    }

    public void destroy() {
        ConfigurationContextProvider.getInstance().getConfigurationContext().cleanupContexts();
    }

    private OMElement createStandardRequest(String symbol) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement method = fac.createOMElement("getQuote", omNs);
        OMElement value1 = fac.createOMElement("request", omNs);
        OMElement value2 = fac.createOMElement("symbol", omNs);
        value2.addChild((OMNode)fac.createOMText((OMContainer)value1, symbol));
        value1.addChild((OMNode)value2);
        method.addChild((OMNode)value1);
        return method;
    }

    private OMElement createStandardSimpleRequest(String symbol) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement method = fac.createOMElement("getSimpleQuote", omNs);
        OMElement value1 = fac.createOMElement("symbol", omNs);
        value1.addChild((OMNode)fac.createOMText((OMContainer)method, symbol));
        method.addChild((OMNode)value1);
        return method;
    }

    private OMElement createMultipleQuoteRequest(String symbol, int iterations) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement method = fac.createOMElement("getQuote", omNs);
        for (int i = 0; i < iterations; ++i) {
            OMElement value1 = fac.createOMElement("request", omNs);
            OMElement value2 = fac.createOMElement("symbol", omNs);
            value2.addChild((OMNode)fac.createOMText((OMContainer)value1, symbol));
            value1.addChild((OMNode)value2);
            method.addChild((OMNode)value1);
        }
        return method;
    }

    private OMElement createCustomQuoteRequest(String symbol) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples", "ns");
        OMElement chkPrice = factory.createOMElement("CheckPriceRequest", ns);
        OMElement code = factory.createOMElement("Code", ns);
        chkPrice.addChild((OMNode)code);
        code.setText(symbol);
        return chkPrice;
    }

    private OMElement createMultipleCustomQuoteRequest(String symbol, int iterations) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement method = fac.createOMElement("getQuote", omNs);
        for (int i = 0; i < iterations; ++i) {
            OMElement chkPrice = fac.createOMElement("CheckPriceRequest", omNs);
            OMElement code = fac.createOMElement("Code", omNs);
            chkPrice.addChild((OMNode)code);
            code.setText(symbol);
            method.addChild((OMNode)chkPrice);
        }
        return method;
    }

    private static OMElement buildResponse(OMElement omElement) {
        omElement.build();
        return omElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPlaceOrderRequest(String trpUrl, String addUrl, String symbol) throws AxisFault {
        double price = StockQuoteClient.getRandom(100.0, 0.9, true);
        int quantity = (int)StockQuoteClient.getRandom(10000.0, 1.0, true);
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl, "placeOrder");
        try {
            serviceClient.fireAndForget(this.createPlaceOrderRequest(price, quantity, symbol));
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }

    private static double getRandom(double base, double varience, boolean onlypositive) {
        double rand = Math.random();
        return (base + (double)(rand > 0.5 ? 1 : -1) * varience * base * rand) * (double)(onlypositive ? 1 : (rand > 0.5 ? 1 : -1));
    }

    public OMElement createPlaceOrderRequest(double purchasePrice, int qty, String symbol) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples", "m0");
        OMElement placeOrder = factory.createOMElement("placeOrder", ns);
        OMElement order = factory.createOMElement("order", ns);
        OMElement price = factory.createOMElement("price", ns);
        OMElement quantity = factory.createOMElement("quantity", ns);
        OMElement symb = factory.createOMElement("symbol", ns);
        price.setText(Double.toString(purchasePrice));
        quantity.setText(Integer.toString(qty));
        symb.setText(symbol);
        order.addChild((OMNode)price);
        order.addChild((OMNode)quantity);
        order.addChild((OMNode)symb);
        placeOrder.addChild((OMNode)order);
        return placeOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDualQuoteRequest(String trpUrl, String addUrl, String symbol) throws AxisFault {
        ServiceClient serviceClient = this.getServiceClient(trpUrl, addUrl);
        serviceClient.getOptions().setUseSeparateListener(true);
        try {
            serviceClient.sendReceiveNonBlocking(this.createStandardRequest(symbol), new AxisCallback(){

                public void onMessage(MessageContext messageContext) {
                    log.info((Object)"Response received to the callback");
                }

                public void onFault(MessageContext messageContext) {
                    log.info((Object)("Fault received to the callback : " + messageContext.getEnvelope().getBody().getFault()));
                }

                public void onError(Exception e) {
                    log.error((Object)"Error inside callback", (Throwable)e);
                }

                public void onComplete() {
                    log.info((Object)"OnComplete called....");
                }
            });
        }
        finally {
            serviceClient.cleanupTransport();
        }
    }
}

