/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONClient {
    private static final Log log = LogFactory.getLog(JSONClient.class);

    public JSONObject sendSimpleStockQuoteRequest(String trpUrl, String symbol) throws IOException, JSONException {
        String query = "{\"getQuote\":{\"request\":{\"symbol\":\"" + symbol + "\"}}}";
        return this.sendRequest(trpUrl, query);
    }

    public JSONObject sendSimpleStockQuoteRequest(String trpUrl, String symbol, String operation) throws IOException, JSONException {
        String query = "{\"getQuote\":{\"request\":{\"symbol\":\"" + symbol + "\"}}}";
        return this.sendRequest(trpUrl, query, operation);
    }

    public JSONObject sendRequest(String trpUrl, JSONObject payload, String operation) throws IOException, JSONException {
        return this.sendRequest(trpUrl, payload.toString(), operation);
    }

    public JSONObject sendUserDefineRequest(String addUrl, String query) throws IOException, JSONException {
        return this.sendRequest(addUrl, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject sendRequest(String addUrl, String query) throws IOException, JSONException {
        String charset = "UTF-8";
        URLConnection connection = new URL(addUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept-Charset", charset);
        connection.setRequestProperty("Content-Type", "application/json;charset=" + charset);
        OutputStream output = null;
        try {
            output = connection.getOutputStream();
            output.write(query.getBytes(charset));
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException logOrIgnore) {
                    log.error((Object)"Error while closing the connection");
                }
            }
        }
        InputStream response = connection.getInputStream();
        String out = "[Fault] No Response.";
        if (response != null) {
            int len;
            StringBuilder sb = new StringBuilder();
            byte[] bytes = new byte[1024];
            while ((len = response.read(bytes)) != -1) {
                sb.append(new String(bytes, 0, len));
            }
            out = sb.toString();
        }
        if (!out.isEmpty()) {
            return new JSONObject(out);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject sendRequest(String addUrl, String query, String action) throws IOException, JSONException {
        String charset = "UTF-8";
        URLConnection connection = new URL(addUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept-Charset", charset);
        connection.setRequestProperty("SOAPAction", action);
        connection.setRequestProperty("Content-Type", "application/json;charset=" + charset);
        OutputStream output = null;
        try {
            output = connection.getOutputStream();
            output.write(query.getBytes(charset));
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException logOrIgnore) {
                    log.error((Object)"Error while closing the connection");
                }
            }
        }
        InputStream response = connection.getInputStream();
        String out = "[Fault] No Response.";
        if (response != null) {
            int len;
            StringBuilder sb = new StringBuilder();
            byte[] bytes = new byte[1024];
            while ((len = response.read(bytes)) != -1) {
                sb.append(new String(bytes, 0, len));
            }
            out = sb.toString();
        }
        if (!out.isEmpty()) {
            return new JSONObject(out);
        }
        return null;
    }
}

