/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients;

import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import java.util.Date;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class GreenMailClient {
    private GreenMailUser greenMailUser;
    private static final String FROM_ADDRESS = "some@mail.com";
    private static final String TO_ADDRESS = "wso2@localhost";

    public GreenMailClient(GreenMailUser greenMailUser) {
        this.greenMailUser = greenMailUser;
    }

    public void sendMail(String subject) throws MessagingException, UserException {
        MimeMessage message = this.createBasicMessage(subject);
        this.greenMailUser.deliver(message);
    }

    public void sendMail(String subject, Map<String, String> headers) throws MessagingException, UserException {
        MimeMessage message = this.createBasicMessage(subject);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            message.addHeader(entry.getKey(), entry.getValue());
        }
        this.greenMailUser.deliver(message);
    }

    private MimeMessage createBasicMessage(String subject) throws MessagingException {
        MimeMessage message = new MimeMessage((Session)null);
        message.setFrom((Address)new InternetAddress(FROM_ADDRESS));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(TO_ADDRESS));
        message.setSubject(subject);
        message.setText("Content :" + subject);
        message.setSentDate(new Date());
        return message;
    }
}

