/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.common;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.dbutils.DatabaseFactory;
import org.wso2.carbon.automation.test.utils.dbutils.DatabaseManager;
import org.wso2.carbon.automation.test.utils.dbutils.H2DataBaseManager;

public class SqlDataSourceUtil {
    private static final Log log = LogFactory.getLog(SqlDataSourceUtil.class);
    private String jdbcUrl = null;
    private String jdbcDriver = null;
    private String databaseName;
    private String databaseUser;
    private String databasePassword;
    private AutomationContext automationContext;
    private String dssBackEndUrl;
    private String sessionCookie;
    private String rssEnvironment;
    private String rssInstanceName;
    private final String userPrivilegeGroupName = "automation";

    public SqlDataSourceUtil(String sessionCookie, String backEndUrl) {
        this.sessionCookie = sessionCookie;
        this.dssBackEndUrl = backEndUrl;
    }

    protected void init() throws XPathExpressionException {
        this.automationContext = new AutomationContext();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public int getDatabaseUserId() {
        return -1;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcUrlForProxy() throws XPathExpressionException {
        String url = this.automationContext.getConfigurationValue("//datasources/datasource/url");
        String datasourceName = null;
        if (url.startsWith("jdbc:h2:")) {
            datasourceName = url.replace("jdbc:h2:", "");
        }
        if (url.endsWith(datasourceName)) {
            url = url.replace(datasourceName, "");
        }
        if ((url = url + FrameworkPathUtil.getSystemSettingsLocation()).endsWith("/src/test/resources/")) {
            url = url.replace("/src/test/resources/", "");
        }
        url = url + File.separator + "target" + File.separator + datasourceName + this.databaseName;
        return url;
    }

    public String getDriver() {
        return this.jdbcDriver;
    }

    public DataHandler createArtifact(String dbsFilePath) throws XMLStreamException, IOException, XPathExpressionException {
        if (this.automationContext == null) {
            this.init();
        }
        Assert.assertNotNull((Object)this.jdbcUrl, (String)"Initialize jdbcUrl");
        try {
            OMElement dbsFile = AXIOMUtil.stringToOM((String)FileManager.readFile((String)dbsFilePath));
            OMElement dbsConfig = dbsFile.getFirstChildWithName(new QName("config"));
            Iterator configElement1 = dbsConfig.getChildElements();
            while (configElement1.hasNext()) {
                OMElement property = (OMElement)configElement1.next();
                String value = property.getAttributeValue(new QName("name"));
                if ("org.wso2.ws.dataservice.protocol".equals(value)) {
                    property.setText(this.jdbcUrl);
                    continue;
                }
                if ("org.wso2.ws.dataservice.driver".equals(value)) {
                    property.setText(this.jdbcDriver);
                    continue;
                }
                if ("org.wso2.ws.dataservice.user".equals(value)) {
                    property.setText(this.databaseUser);
                    continue;
                }
                if (!"org.wso2.ws.dataservice.password".equals(value)) continue;
                property.setText(this.databasePassword);
            }
            log.debug((Object)dbsFile);
            ByteArrayDataSource dbs = new ByteArrayDataSource(dbsFile.toString().getBytes());
            return new DataHandler((DataSource)dbs);
        }
        catch (XMLStreamException e) {
            log.error((Object)"XMLStreamException when Reading Service File", (Throwable)e);
            throw new XMLStreamException("XMLStreamException when Reading Service File", e);
        }
        catch (IOException e) {
            log.error((Object)"IOException when Reading Service File", (Throwable)e);
            throw new IOException("IOException  when Reading Service File", e);
        }
    }

    private void createDataBase(String driver, String jdbc, String user, String password) throws ClassNotFoundException, SQLException, XPathExpressionException {
        if (this.automationContext == null) {
            this.init();
        }
        try {
            DatabaseManager dbm = DatabaseFactory.getDatabaseConnector((String)driver, (String)jdbc, (String)user, (String)password);
            dbm.executeUpdate("DROP DATABASE IF EXISTS " + this.databaseName);
            dbm.executeUpdate("CREATE DATABASE " + this.databaseName);
            this.jdbcUrl = jdbc + "/" + this.databaseName;
            dbm.disconnect();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Class Not Found. Check MySql-jdbc Driver in classpath: ", (Throwable)e);
            throw new ClassNotFoundException("Class Not Found. Check MySql-jdbc Driver in classpath: ", e);
        }
        catch (SQLException e) {
            log.error((Object)"SQLException When executing SQL: ", (Throwable)e);
            throw new SQLException("SQLException When executing SQL: ", e);
        }
    }

    public void createDataSource(List<File> sqlFileList) throws Exception {
        if (this.automationContext == null) {
            this.init();
        }
        this.databaseName = "testdb";
        this.databasePassword = this.automationContext.getConfigurationValue("//datasources/datasource/password");
        this.jdbcUrl = this.automationContext.getConfigurationValue("//datasources/datasource/url");
        this.jdbcDriver = this.automationContext.getConfigurationValue("//datasources/datasource/driverClassName");
        this.databaseUser = this.automationContext.getConfigurationValue("//datasources/datasource/username");
        if (this.jdbcUrl.contains("h2") && this.jdbcDriver.contains("h2")) {
            this.databaseName = System.getProperty("basedir") + File.separator + "target" + File.separator + this.databaseName + new Random().nextInt();
            this.jdbcUrl = "jdbc:h2:" + this.databaseName;
            H2DataBaseManager h2 = null;
            try {
                h2 = new H2DataBaseManager(this.jdbcUrl, this.databaseUser, this.databasePassword);
                h2.executeUpdate("DROP ALL OBJECTS");
            }
            finally {
                if (h2 != null) {
                    h2.disconnect();
                }
            }
        } else {
            this.createDataBase(this.jdbcDriver, this.jdbcUrl, this.databaseUser, this.databasePassword);
        }
        this.executeUpdate(sqlFileList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDataSource(String dbName, List<File> sqlFileList) throws Exception {
        if (this.automationContext == null) {
            this.init();
        }
        this.databaseName = dbName + "_" + new Date().getTime();
        this.databasePassword = this.automationContext.getConfigurationValue("//datasources/datasource/password");
        this.jdbcUrl = this.automationContext.getConfigurationValue("//datasources/datasource/url");
        this.jdbcDriver = this.automationContext.getConfigurationValue("//datasources/datasource/driverClassName");
        this.databaseUser = this.automationContext.getConfigurationValue("//datasources/datasource/username");
        if (this.jdbcUrl.contains("h2") && this.jdbcDriver.contains("h2")) {
            this.databaseName = System.getProperty("basedir") + File.separator + "target" + File.separator + this.databaseName;
            this.jdbcUrl = "jdbc:h2:" + this.databaseName;
            H2DataBaseManager h2 = null;
            try {
                h2 = new H2DataBaseManager(this.jdbcUrl, this.databaseUser, this.databasePassword);
                h2.executeUpdate("DROP ALL OBJECTS");
            }
            finally {
                if (h2 != null) {
                    h2.disconnect();
                }
            }
        } else {
            this.createDataBase(this.jdbcDriver, this.jdbcUrl, this.databaseUser, this.databasePassword);
        }
        this.executeUpdate(sqlFileList);
    }

    private void executeUpdate(List<File> sqlFileList) throws IOException, ClassNotFoundException, SQLException, XPathExpressionException {
        DatabaseManager dbm = null;
        try {
            dbm = DatabaseFactory.getDatabaseConnector((String)this.jdbcDriver, (String)this.jdbcUrl, (String)this.databaseUser, (String)this.databasePassword);
            for (File sql : sqlFileList) {
                dbm.executeUpdate(sql);
            }
        }
        catch (IOException e) {
            log.error((Object)"IOException When reading SQL files: ", (Throwable)e);
            throw new IOException("IOException When reading SQL files: ", e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Class Not Found. Check MySql-jdbc Driver in classpath: " + e));
            throw new ClassNotFoundException("Class Not Found. Check MySql-jdbc Driver in classpath: ", e);
        }
        catch (SQLException e) {
            log.error((Object)("SQLException When executing SQL: " + e));
            throw new SQLException("SQLException When executing SQL: ", e);
        }
        finally {
            if (dbm != null) {
                dbm.disconnect();
            }
        }
    }
}

