/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients;

import java.io.File;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.esb.integration.common.utils.clients.axis2client.SecureAxisServiceClient;
import org.wso2.esb.integration.common.utils.common.TestConfigurationProvider;

public class SecureServiceClient {
    private SecureAxisServiceClient secureClient = new SecureAxisServiceClient();

    public OMElement sendSecuredStockQuoteRequest(User userInfo, String trpUrl, int securityPolicyId, String symbol) throws Exception {
        return this.sendSecuredRequest(userInfo, trpUrl, securityPolicyId, this.createSimpleStockQuoteRequest(symbol), "getQuote");
    }

    public OMElement sendSecuredRequest(User userInfo, String trpUrl, int securityPolicyId, OMElement payload, String action) throws Exception {
        String keyStorePassword;
        String encryptionUser;
        String userCertAlias;
        String keyStorePath;
        boolean isTenant = false;
        String policyPath = TestConfigurationProvider.getSecurityPolicyLocation() + File.separator + "scenario" + securityPolicyId + "-policy.xml";
        if (isTenant) {
            keyStorePath = TestConfigurationProvider.getResourceLocation() + File.separator + "security" + File.separator + "keystore" + File.separator + "clients.jks";
            userCertAlias = "clients";
            encryptionUser = "service";
            keyStorePassword = "automation";
        } else {
            keyStorePath = TestConfigurationProvider.getResourceLocation() + File.separator + "keystores" + File.separator + "products" + File.separator + "wso2carbon.jks";
            userCertAlias = "wso2carbon";
            encryptionUser = "wso2carbon";
            keyStorePassword = "wso2carbon";
        }
        return this.secureClient.sendReceive(userInfo.getUserName(), userInfo.getPassword(), trpUrl, action, payload, policyPath, userCertAlias, encryptionUser, keyStorePath, keyStorePassword);
    }

    public OMElement sendSecuredStockQuoteRequest(User userInfo, String trpUrl, String symbol, boolean teant) throws Exception {
        String keyStorePassword;
        String encryptionUser;
        String userCertAlias;
        String keyStorePath;
        boolean isTenant = teant;
        if (isTenant) {
            keyStorePath = TestConfigurationProvider.getResourceLocation() + File.separator + "security" + File.separator + "keystore" + File.separator + "wso2carbon.jks";
            userCertAlias = "wso2carbon";
            encryptionUser = "wso2carbon";
            keyStorePassword = "wso2carbon";
        } else {
            keyStorePath = TestConfigurationProvider.getResourceLocation() + File.separator + "keystores" + File.separator + "products" + File.separator + "wso2carbon.jks";
            userCertAlias = "wso2carbon";
            encryptionUser = "wso2carbon";
            keyStorePassword = "wso2carbon";
        }
        return this.secureClient.sendReceive(userInfo.getUserName(), userInfo.getPassword(), trpUrl, "getQuote", this.createSimpleStockQuoteRequest(symbol), null, userCertAlias, encryptionUser, keyStorePath, keyStorePassword);
    }

    private OMElement createSimpleStockQuoteRequest(String symbol) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement method = fac.createOMElement("getQuote", omNs);
        OMElement value1 = fac.createOMElement("request", omNs);
        OMElement value2 = fac.createOMElement("symbol", omNs);
        value2.addChild((OMNode)fac.createOMText((OMContainer)value1, symbol));
        value1.addChild((OMNode)value2);
        method.addChild((OMNode)value1);
        return method;
    }
}

