/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers.axis2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.esb.integration.common.utils.servers.axis2.BackendServer;

public class SampleAxis2Server
implements BackendServer {
    public static final String SIMPLE_STOCK_QUOTE_SERVICE = "SimpleStockQuoteService";
    public static final String SIMPLE_STOCK_QUOTE_SERVICE_2 = "SimpleStockQuoteService2";
    public static final String SIMPLE_STOCK_QUOTE_SERVICE_3 = "SimpleStockQuoteService3";
    public static final String SECURE_STOCK_QUOTE_SERVICE = "SecureStockQuoteService";
    public static final String LB_SERVICE_1 = "LBService1";
    public static final String LB_SERVICE_2 = "LBService2";
    public static final String LB_SERVICE_3 = "LBService3";
    public static final String LB_SERVICE_4 = "LBService4";
    public static final String SIMPLE_AXIS2_SERVICE = "Axis2Service";
    public static final String STUDENT_REST_SERVICE = "StudentService";
    private static final Log log = LogFactory.getLog(SampleAxis2Server.class);
    String repositoryPath = System.getProperty("carbon.home") + File.separator + "samples" + File.separator + "axis2Server" + File.separator + "repository";
    private ConfigurationContext cfgCtx;
    private ListenerManager listenerManager;
    private boolean started;

    public SampleAxis2Server() {
        this("test_axis2_server_9000.xml");
        this.repositoryPath = System.getProperty("carbon.home") + File.separator + "samples" + File.separator + "axis2Server" + File.separator + "repository";
    }

    public SampleAxis2Server(String axis2xmlFile) {
        File repository = new File(this.repositoryPath);
        log.info((Object)("Using the Axis2 repository path: " + repository.getAbsolutePath()));
        try {
            File axis2xml = this.copyResourceToFileSystem(axis2xmlFile, "axis2.xml");
            if (axis2xml == null) {
                log.error((Object)"Error while copying the test axis2.xml to the file system");
                return;
            }
            log.info((Object)("Loading axis2.xml from: " + axis2xml.getAbsolutePath()));
            this.cfgCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repository.getAbsolutePath(), (String)axis2xml.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing the configuration context", (Throwable)e);
        }
    }

    @Override
    public void start() throws IOException {
        log.info((Object)"Starting sample Axis2 server");
        if (System.getProperty("http.socket.reuseaddr") == null) {
            System.setProperty("http.socket.reuseaddr", "true");
        }
        this.listenerManager = new ListenerManager();
        this.listenerManager.init(this.cfgCtx);
        this.listenerManager.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.started = true;
    }

    @Override
    public void stop() {
        log.info((Object)"Stopping sample Axis2 server");
        try {
            this.listenerManager.stop();
            this.listenerManager.destroy();
            this.cfgCtx.cleanupContexts();
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while shutting down the listener manager", (Throwable)axisFault);
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return !this.listenerManager.isStopped();
    }

    public void hotDeployArtifact(String artifact) throws IOException {
        File fOrig = new File(artifact);
        File fDest = new File(this.repositoryPath + File.separator + "services" + File.separator);
        FileUtils.copyFile((File)fOrig, (File)fDest);
    }

    public void hotUndeployArtifact(String artifact) {
        File fOrig = new File(artifact);
        FileUtils.deleteQuietly((File)fOrig);
    }

    @Override
    public void deployService(Object service) throws IOException {
        String artifactName = service + ".aar";
        File file = this.copyResourceToFileSystem(artifactName, artifactName);
        AxisServiceGroup serviceGroup = DeploymentEngine.loadServiceGroup((File)file, (ConfigurationContext)this.cfgCtx);
        this.cfgCtx.getAxisConfiguration().addServiceGroup(serviceGroup);
    }

    private File copyResourceToFileSystem(String resourceName, String fileName) throws IOException {
        File file = new File(System.getProperty("basedir") + File.separator + "target" + File.separator + fileName);
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        FileUtils.touch((File)file);
        FileOutputStream os = FileUtils.openOutputStream((File)file);
        FileInputStream is = resourceName.contains(".aar") ? new FileInputStream(FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "AXIS2" + File.separator + "aar" + File.separator + resourceName) : new FileInputStream(FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "AXIS2" + File.separator + "config" + File.separator + resourceName);
        if (is != null) {
            int len;
            byte[] data = new byte[1024];
            while ((len = ((InputStream)is).read(data)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            os.flush();
            ((OutputStream)os).close();
            ((InputStream)is).close();
        }
        return file;
    }

    private File copyServiceToFileSystem(String resourceName, String fileName) throws IOException {
        File file = new File(System.getProperty("basedir") + File.separator + "target" + File.separator + fileName);
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        FileUtils.touch((File)file);
        FileOutputStream os = FileUtils.openOutputStream((File)file);
        FileInputStream is = new FileInputStream(FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "AXIS2" + File.separator + "config" + File.separator + resourceName);
        if (is != null) {
            int len;
            byte[] data = new byte[1024];
            while ((len = ((InputStream)is).read(data)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            os.flush();
            ((OutputStream)os).close();
            ((InputStream)is).close();
        }
        return file;
    }
}

