/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleHTTPServer {
    private static Log log = LogFactory.getLog(SimpleHTTPServer.class);
    private HttpServer httpServer;

    public SimpleHTTPServer(int port) throws IOException {
        this.httpServer = HttpServer.create(new InetSocketAddress(port), 0);
    }

    public HttpContext createContext(String context, Map<String, String> httpHeaders, String responsePayload) {
        return this.httpServer.createContext(context, new DefaultResponseHandler(httpHeaders, responsePayload));
    }

    public HttpContext createContext(String context, HttpHandler handler) {
        return this.httpServer.createContext(context, handler);
    }

    public void start() {
        this.httpServer.setExecutor(null);
        this.httpServer.start();
        log.info((Object)("SimpleHTTPServer started at " + this.httpServer.getAddress().getHostName() + ":" + this.httpServer.getAddress().getPort()));
    }

    public void stop() {
        this.httpServer.stop(0);
        log.info((Object)"SimpleHTTPServer stopped");
    }

    public HttpServer unwrap() {
        return this.httpServer;
    }

    private static class DefaultResponseHandler
    implements HttpHandler {
        Map<String, String> responseHeaders;
        String responsePayload;

        DefaultResponseHandler(Map<String, String> responseHeaders, String responsePayload) {
            this.responseHeaders = responseHeaders;
            this.responsePayload = responsePayload;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            if (this.responseHeaders != null) {
                Headers headers = httpExchange.getResponseHeaders();
                for (Map.Entry<String, String> entry : this.responseHeaders.entrySet()) {
                    headers.add(entry.getKey(), entry.getValue());
                }
            }
            httpExchange.sendResponseHeaders(200, this.responsePayload.length());
            try (OutputStream responseStream = httpExchange.getResponseBody();){
                responseStream.write(this.responsePayload.getBytes(Charset.defaultCharset()));
            }
        }
    }
}

