/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpServerRunner {
    private final SftpServer sftpServer;

    public SftpServerRunner(int port, String ftpFolderPath, String userName, String password) {
        this.sftpServer = new SftpServer(port, ftpFolderPath, userName, password);
    }

    public SftpServerRunner(SshServer sshServer) {
        this.sftpServer = new SftpServer(sshServer);
    }

    public void start() {
        Thread thread = new Thread(this.sftpServer);
        thread.start();
    }

    public void stop() {
        this.sftpServer.stop();
    }

    private class SftpServer
    implements Runnable {
        private final Logger LOGGER = LoggerFactory.getLogger(SftpServer.class);
        private SshServer sshd = SshServer.setUpDefaultServer();

        SftpServer(int port, String path, String ftpUser, String ftpPassword) {
            this.sshd.setPort(port);
            this.sshd.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
            this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
            this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
            this.sshd.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(Paths.get(path, new String[0])));
            this.sshd.setPasswordAuthenticator((username, password, session) -> StringUtils.equals((CharSequence)username, (CharSequence)ftpUser) && StringUtils.equals((CharSequence)password, (CharSequence)ftpPassword));
        }

        SftpServer(SshServer sshServer) {
            this.sshd = sshServer;
        }

        @Override
        public void run() {
            try {
                this.LOGGER.info("Starting SFTP server on port {}", (Object)this.sshd.getPort());
                this.sshd.start();
            }
            catch (IOException e) {
                this.LOGGER.error("Error starting SFTP server", (Throwable)e);
            }
        }

        private void stop() {
            try {
                this.sshd.stop();
            }
            catch (IOException e) {
                this.LOGGER.error("Error stopping SFTP server", (Throwable)e);
            }
        }
    }
}

