/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.coverage;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.ArchiveExtractorUtil;
import org.wso2.carbon.automation.engine.frameworkutils.CodeCoverageUtils;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.engine.frameworkutils.ReportGenerator;

public class TestCoverageGenerator {
    private static final Log log = LogFactory.getLog(TestCoverageGenerator.class);
    private static String carbonZip;

    public static void main(String[] args) throws AutomationFrameworkException, IOException {
        if (carbonZip == null) {
            carbonZip = FrameworkPathUtil.getCarbonZipLocation();
            log.info((Object)("Using carbon zip file at  " + carbonZip));
        }
        if (carbonZip == null) {
            throw new IllegalArgumentException("carbon zip file cannot find in the given location " + FrameworkPathUtil.getCarbonZipLocation());
        }
        String carbonHome = ArchiveExtractorUtil.setUpCarbonHome((String)carbonZip);
        File parentDirectory = new File(System.getProperty("basedir")).getParentFile();
        CodeCoverageUtils.executeMerge((String)parentDirectory.getAbsolutePath(), (String)FrameworkPathUtil.getCoverageMergeFilePath());
        File carbonPluginDir = new File(carbonHome + File.separator + "wso2" + File.separator + "components" + File.separator + "plugins" + File.separator);
        ReportGenerator reportGenerator = new ReportGenerator(new File(FrameworkPathUtil.getCoverageMergeFilePath()), carbonPluginDir, new File(CodeCoverageUtils.getJacocoReportDirectory()), null);
        reportGenerator.create();
        File carbonHomeDir = new File(carbonHome);
        if (carbonHomeDir.exists()) {
            FileUtils.deleteQuietly((File)new File(carbonHome));
        }
        log.info((Object)("Jacoco coverage merged file : " + FrameworkPathUtil.getCoverageMergeFilePath()));
        log.info((Object)("Jacoco class file path : " + carbonPluginDir.getAbsolutePath()));
        log.info((Object)("Jacoco coverage HTML report path : " + CodeCoverageUtils.getJacocoReportDirectory() + File.separator + "index.html"));
    }
}

