/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients.jmsclient;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfiguration;

public class JMSQueueMessageProducer {
    private static final Log logger = LogFactory.getLog(JMSQueueMessageProducer.class);
    private static final String MB_BROKER_URL_PREFIX = "amqp://";
    private Connection connection = null;
    private Session session = null;
    private MessageProducer producer = null;
    private QueueConnectionFactory connectionFactory = null;

    public JMSQueueMessageProducer(JMSBrokerConfiguration jmsBrokerConfiguration) throws NamingException {
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", jmsBrokerConfiguration.getInitialNamingFactory());
        if (jmsBrokerConfiguration.getProviderURL().startsWith(MB_BROKER_URL_PREFIX)) {
            properties.put("connectionfactory.QueueConnectionFactory", jmsBrokerConfiguration.getProviderURL());
        } else {
            properties.setProperty("java.naming.provider.url", jmsBrokerConfiguration.getProviderURL());
        }
        InitialContext context = new InitialContext(properties);
        this.connectionFactory = (QueueConnectionFactory)context.lookup("QueueConnectionFactory");
    }

    public void connect(String queueName) throws JMSException {
        this.connect(queueName, false);
    }

    public void connect(String queueName, boolean persistMessage) throws JMSException {
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        Queue destination = this.session.createQueue(queueName);
        this.producer = this.session.createProducer((Destination)destination);
        if (persistMessage) {
            this.producer.setDeliveryMode(2);
        } else {
            this.producer.setDeliveryMode(1);
        }
    }

    public void disconnect() {
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException e) {
            logger.warn((Object)"JMSException thrown while disconnecting ", (Throwable)e);
        }
    }

    public void sendMessage(Message message) throws JMSException {
        this.checkIfConnected();
        this.producer.send(message);
    }

    public void sendTextMessage(String payload) throws JMSException {
        this.checkIfConnected();
        TextMessage textMessage = this.session.createTextMessage(payload);
        this.producer.send((Message)textMessage);
    }

    public void sendBytesMessage(byte[] payload) throws JMSException {
        this.checkIfConnected();
        BytesMessage bytesMessage = this.session.createBytesMessage();
        bytesMessage.writeBytes(payload);
        this.producer.send((Message)bytesMessage);
    }

    public void sendStreamMessage(byte[] payload) throws JMSException {
        this.checkIfConnected();
        StreamMessage streamMessage = this.session.createStreamMessage();
        streamMessage.writeBytes(payload);
        this.producer.send((Message)streamMessage);
    }

    public void sendMapMessage() throws JMSException {
        this.checkIfConnected();
        MapMessage mapMessage = this.session.createMapMessage();
        this.producer.send((Message)mapMessage);
    }

    public void sendObjectMessage(Serializable payload) throws JMSException {
        this.checkIfConnected();
        ObjectMessage objectMessage = this.session.createObjectMessage(payload);
        this.producer.send((Message)objectMessage);
    }

    private void checkIfConnected() throws IllegalStateException {
        if (this.session == null || this.producer == null) {
            throw new IllegalStateException("No connection to a queue. Connection needs to be established to send messages");
        }
    }
}

