/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients.axis2client;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.esb.integration.common.utils.clients.axis2client.ClientUtils;

public class AxisServiceClient {
    private static final Log log = LogFactory.getLog(AxisServiceClient.class);

    public OMElement sendReceive(OMElement payload, String endPointReference, String operation) throws AxisFault {
        OMElement response = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service Endpoint : " + endPointReference));
            log.debug((Object)("Service Operation : " + operation));
            log.debug((Object)("Payload : " + payload));
        }
        try {
            ServiceClient sender = new ServiceClient();
            Options options = new Options();
            options.setTo(new EndpointReference(endPointReference));
            options.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            options.setTimeOutInMilliSeconds((long)ClientUtils.getReadTimeout());
            options.setAction("urn:" + operation);
            sender.setOptions(options);
            response = sender.sendReceive(payload);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response Message : " + response));
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault.getMessage());
            throw new AxisFault("AxisFault while getting response :" + axisFault.getMessage(), (Throwable)axisFault);
        }
        Assert.assertNotNull((Object)response);
        return response;
    }

    public OMElement sendReceive(OMElement payload, String endPointReference, String operation, String localName, String ns, String value) throws AxisFault {
        OMElement response = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service Endpoint : " + endPointReference));
            log.debug((Object)("Service Operation : " + operation));
            log.debug((Object)("Payload : " + payload));
        }
        try {
            ServiceClient sender = new ServiceClient();
            sender.addStringHeader(new QName(ns, localName), value);
            Options options = new Options();
            options.setTo(new EndpointReference(endPointReference));
            options.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            options.setAction("urn:" + operation);
            sender.setOptions(options);
            response = sender.sendReceive(payload);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response Message : " + response));
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault.getMessage());
            throw new AxisFault("AxisFault while getting response :" + axisFault.getMessage(), (Throwable)axisFault);
        }
        Assert.assertNotNull((Object)response);
        return response;
    }

    public OMElement sendReceive(OMElement payload, String endPointReference, String operation, String contentType) throws AxisFault {
        OMElement response = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service Endpoint : " + endPointReference));
            log.debug((Object)("Service Operation : " + operation));
            log.debug((Object)("Payload : " + payload));
        }
        try {
            ServiceClient sender = new ServiceClient();
            Options options = new Options();
            options.setTo(new EndpointReference(endPointReference));
            options.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            options.setTimeOutInMilliSeconds(45000L);
            options.setAction("urn:" + operation);
            options.setProperty("messageType", (Object)contentType);
            sender.setOptions(options);
            response = sender.sendReceive(payload);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response Message : " + response));
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault.getMessage());
            throw new AxisFault("AxisFault while getting response :" + axisFault.getMessage(), (Throwable)axisFault);
        }
        Assert.assertNotNull((Object)response);
        return response;
    }

    public void sendRobust(OMElement payload, String endPointReference, String operation) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.info((Object)("Service Endpoint : " + endPointReference));
            log.info((Object)("Service Operation : " + operation));
            log.debug((Object)("Payload : " + payload));
        }
        try {
            ServiceClient sender = new ServiceClient();
            Options options = new Options();
            options.setTo(new EndpointReference(endPointReference));
            options.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            options.setAction("urn:" + operation);
            sender.setOptions(options);
            sender.sendRobust(payload);
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault.getMessage());
            throw new AxisFault("AxisFault while getting response :" + axisFault.getMessage(), (Throwable)axisFault);
        }
    }

    public void fireAndForget(OMElement payload, String endPointReference, String operation) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.info((Object)("Service Endpoint : " + endPointReference));
            log.info((Object)("Service Operation : " + operation));
            log.debug((Object)("Payload : " + payload));
        }
        try {
            ServiceClient sender = new ServiceClient();
            Options options = new Options();
            options.setTo(new EndpointReference(endPointReference));
            options.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            options.setAction("urn:" + operation);
            sender.setOptions(options);
            sender.fireAndForget(payload);
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault.getMessage());
            throw new AxisFault("AxisFault while getting response :" + axisFault.getMessage(), (Throwable)axisFault);
        }
    }
}

