/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMXClient {
    private static final Log log = LogFactory.getLog(JMXClient.class);
    private MBeanServerConnection mbsc = null;
    private String userName;
    private String password;
    private ObjectName objectName;
    private String hostName;
    private String rmiServerPort;
    private String rmiRegistryPort;
    private JMXConnector jmxc;

    public JMXClient(String connectionName, String hostName, String rmiServerPort, String rmiRegistryPort, String userName, String password) throws MalformedObjectNameException {
        this.objectName = new ObjectName(connectionName);
        this.userName = userName;
        this.password = password;
        this.hostName = hostName;
        this.rmiServerPort = rmiServerPort;
        this.rmiRegistryPort = rmiRegistryPort;
    }

    public MBeanServerConnection connect() throws IOException, MalformedObjectNameException {
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://localhost:" + this.rmiServerPort + "/jndi/rmi://" + this.hostName + ":" + this.rmiRegistryPort + "/jmxrmi");
            Hashtable<String, String[]> hashT = new Hashtable<String, String[]>();
            String[] credentials = new String[]{this.userName, this.password};
            hashT.put("jmx.remote.credentials", credentials);
            this.jmxc = JMXConnectorFactory.connect(url, hashT);
            this.mbsc = this.jmxc.getMBeanServerConnection();
            if (this.mbsc != null) {
                return this.mbsc;
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)"Error while creating Jmx connection ", (Throwable)e);
            throw new MalformedURLException();
        }
        catch (IOException e) {
            log.error((Object)"Error while creating Jmx connection ", (Throwable)e);
            throw new IOException("Error while creating Jmx connection " + e);
        }
        return null;
    }

    public void disconnect() throws ListenerNotFoundException, InstanceNotFoundException, IOException {
        if (this.jmxc != null) {
            log.info((Object)"Closing jmx client connection...............");
            this.jmxc.close();
        }
        if (this.mbsc != null) {
            this.mbsc = null;
        }
    }

    public Object invoke(String operationName, Object[] params, String[] signatureTypes) throws Exception {
        try {
            return this.mbsc.invoke(this.objectName, operationName, params, signatureTypes);
        }
        catch (Exception e) {
            log.error((Object)("Operation invocation fail " + e));
            throw new Exception("Operation invocation fail " + e);
        }
    }

    public Object getAttribute(String attribute) throws Exception {
        try {
            return this.mbsc.getAttribute(this.objectName, attribute);
        }
        catch (Exception e) {
            log.error((Object)("Unable to get attribute " + e));
            throw new Exception("Unable to get attribute  " + e);
        }
    }
}

