/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.logging;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.logging.admin.stub.LoggingAdminStub;
import org.wso2.carbon.logging.admin.stub.types.carbon.AppenderData;
import org.wso2.carbon.logging.admin.stub.types.carbon.LogData;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class LoggingAdminClient {
    private static final Log log = LogFactory.getLog(LoggingAdminClient.class);
    private final String serviceName = "LoggingAdmin";
    private String endpoint = null;
    private LoggingAdminStub loggingAdminStub;

    public LoggingAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        this.endpoint = backEndUrl + "LoggingAdmin";
        this.loggingAdminStub = new LoggingAdminStub(this.endpoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.loggingAdminStub);
    }

    public LoggingAdminClient(String backEndURL, String userName, String password) throws AxisFault {
        this.endpoint = backEndURL + "LoggingAdmin";
        this.loggingAdminStub = new LoggingAdminStub(this.endpoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.loggingAdminStub);
    }

    public boolean updateLoggerData(String loggerName, String logLevel, boolean additivity, boolean persist) throws Exception {
        this.loggingAdminStub.updateLoggerData(loggerName, logLevel, additivity, persist);
        return true;
    }

    public void updateSystemLog(String logLevel, String logPattern, boolean persist) throws Exception {
        try {
            this.loggingAdminStub.updateSystemLog(logLevel, logPattern, persist);
        }
        catch (Exception e) {
            String msg = "Error occurred while updating global log4j configuration.";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public LogData getSysLog() throws Exception {
        try {
            return this.loggingAdminStub.getSystemLog();
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting global logging configuration. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void restoreToDefaults() throws Exception {
        try {
            ServiceClient client = this.loggingAdminStub._getServiceClient();
            Options option = client.getOptions();
            option.setTimeOutInMilliSeconds(180000L);
            this.loggingAdminStub.restoreDefaults();
        }
        catch (Exception e) {
            String msg = "Error occurred while restoring global log4j configuration.";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public AppenderData getAppenderData(String appenderName) throws Exception {
        try {
            return this.loggingAdminStub.getAppenderData(appenderName);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting log4j appender data.";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public static enum LogLevel {
        OFF,
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

