/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.endpoint;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.endpoint.stub.types.EndpointAdminEndpointAdminException;
import org.wso2.carbon.endpoint.stub.types.EndpointAdminStub;
import org.wso2.carbon.endpoint.stub.types.service.EndpointMetaData;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class EndPointAdminClient {
    private static final Log log = LogFactory.getLog(EndPointAdminClient.class);
    private final String serviceName = "EndpointAdmin";
    private EndpointAdminStub endpointAdminStub;

    public EndPointAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "EndpointAdmin";
        this.endpointAdminStub = new EndpointAdminStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.endpointAdminStub);
    }

    public EndPointAdminClient(String backEndURL, String userName, String password) throws AxisFault {
        String endPoint = backEndURL + "EndpointAdmin";
        this.endpointAdminStub = new EndpointAdminStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.endpointAdminStub);
    }

    public boolean addEndPoint(DataHandler dh) throws EndpointAdminEndpointAdminException, IOException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement endPointElem = builder.getDocumentElement();
        return this.endpointAdminStub.addEndpoint(endPointElem.toString());
    }

    public boolean addEndPoint(OMElement endPointElem) throws EndpointAdminEndpointAdminException, IOException, XMLStreamException {
        return this.endpointAdminStub.addEndpoint(endPointElem.toString());
    }

    public boolean addDynamicEndPoint(String key, DataHandler dh) throws EndpointAdminEndpointAdminException, IOException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement endPointElem = builder.getDocumentElement();
        return this.endpointAdminStub.addDynamicEndpoint(key, endPointElem.toString());
    }

    public boolean addDynamicEndPoint(String key, OMElement endPointElem) throws EndpointAdminEndpointAdminException, IOException, XMLStreamException {
        return this.endpointAdminStub.addDynamicEndpoint(key, endPointElem.toString());
    }

    public int getEndpointCount() throws EndpointAdminEndpointAdminException, RemoteException {
        return this.endpointAdminStub.getEndpointCount();
    }

    public String[] getEndpointNames() throws EndpointAdminEndpointAdminException, RemoteException {
        return this.endpointAdminStub.getEndPointsNames();
    }

    public int getDynamicEndpointCount() throws EndpointAdminEndpointAdminException, RemoteException {
        return this.endpointAdminStub.getDynamicEndpointCount();
    }

    public String getDynamicEndpoint(String key) throws EndpointAdminEndpointAdminException, RemoteException {
        return this.endpointAdminStub.getDynamicEndpoint(key);
    }

    public String[] getDynamicEndpoints() throws EndpointAdminEndpointAdminException, RemoteException {
        return this.endpointAdminStub.getDynamicEndpoints();
    }

    public void enableEndpointStatistics(String endpointName) throws RemoteException, EndpointAdminEndpointAdminException {
        this.endpointAdminStub.enableStatistics(endpointName);
        String endpoint = this.endpointAdminStub.getEndpointConfiguration(endpointName);
        assert (endpoint.contains("statistics=\"enable"));
    }

    public boolean deleteEndpoint(String endpointName) throws RemoteException, EndpointAdminEndpointAdminException {
        return this.endpointAdminStub.deleteEndpoint(endpointName);
    }

    public boolean deleteDynamicEndpoint(String key) throws RemoteException, EndpointAdminEndpointAdminException {
        return this.endpointAdminStub.deleteDynamicEndpoint(key);
    }

    public String getEndpointConfiguration(String endpointName) throws RemoteException, EndpointAdminEndpointAdminException {
        return this.endpointAdminStub.getEndpointConfiguration(endpointName);
    }

    public EndpointMetaData[] getEndpointsData() throws EndpointAdminEndpointAdminException, IOException, XMLStreamException {
        return this.endpointAdminStub.getEndpointsData();
    }
}

