/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.mediation;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.stub.internal.TopicManagerAdminServiceStub;
import org.wso2.carbon.event.stub.internal.xsd.TopicNode;

public class TopicAdminClient {
    private static final Log log = LogFactory.getLog(TopicAdminClient.class);
    String backendUrl = null;
    String SessionCookie = null;
    ConfigurationContext configurationContext = null;

    public TopicAdminClient(String backendUrl, String sessionCookie, ConfigurationContext configurationContext) {
        this.backendUrl = backendUrl + "TopicManagerAdminService.TopicManagerAdminServiceHttpsSoap12Endpoint";
        this.SessionCookie = sessionCookie;
        this.configurationContext = configurationContext;
    }

    public void addTopic(String topic) throws Exception {
        TopicManagerAdminServiceStub stub = new TopicManagerAdminServiceStub(this.configurationContext, this.backendUrl);
        this.configureCookie(stub._getServiceClient());
        stub.addTopic(topic);
    }

    public TopicNode getAllTopics() throws Exception {
        TopicManagerAdminServiceStub stub = new TopicManagerAdminServiceStub(this.configurationContext, this.backendUrl);
        this.configureCookie(stub._getServiceClient());
        return stub.getAllTopics();
    }

    public void removeTopic(String topic) throws Exception {
        TopicManagerAdminServiceStub stub = new TopicManagerAdminServiceStub(this.configurationContext, this.backendUrl);
        this.configureCookie(stub._getServiceClient());
        stub.removeTopic(topic);
    }

    private void configureCookie(ServiceClient client) throws AxisFault {
        if (this.SessionCookie != null) {
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)this.SessionCookie);
        }
    }
}

