/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.mediation;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.message.store.stub.Exception;
import org.wso2.carbon.message.store.stub.MessageInfo;
import org.wso2.carbon.message.store.stub.MessageStoreAdminServiceStub;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class MessageStoreAdminClient {
    private static final Log log = LogFactory.getLog(MessageStoreAdminClient.class);
    private MessageStoreAdminServiceStub messageStoreAdminServiceStub;
    private final String serviceName = "MessageStoreAdminService";

    public MessageStoreAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "MessageStoreAdminService";
        this.messageStoreAdminServiceStub = new MessageStoreAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.messageStoreAdminServiceStub);
    }

    public MessageStoreAdminClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "MessageStoreAdminService";
        this.messageStoreAdminServiceStub = new MessageStoreAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.messageStoreAdminServiceStub);
    }

    public void addMessageStore(DataHandler dh) throws IOException, XMLStreamException, Exception {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement messageStore = builder.getDocumentElement();
        this.messageStoreAdminServiceStub.addMessageStore(messageStore.toString());
    }

    public void addMessageStore(OMElement messageStore) throws RemoteException, Exception {
        this.messageStoreAdminServiceStub.addMessageStore(messageStore.toString());
    }

    public void updateMessageStore(OMElement messageStore) throws RemoteException {
        this.messageStoreAdminServiceStub.modifyMessageStore(messageStore.toString());
    }

    public void deleteMessageStore(String messageStoreName) throws RemoteException {
        this.messageStoreAdminServiceStub.deleteMessageStore(messageStoreName);
    }

    public void deleteMessage(String storeName, String messageId) throws RemoteException {
        this.messageStoreAdminServiceStub.deleteMessage(storeName, messageId);
    }

    public String[] getMessageStores() throws RemoteException {
        return this.messageStoreAdminServiceStub.getMessageStoreNames();
    }

    public int getMessageCount(String storeName) throws RemoteException {
        return this.messageStoreAdminServiceStub.getSize(storeName);
    }

    public MessageInfo[] getAllMessages(String storeName) throws RemoteException {
        return this.messageStoreAdminServiceStub.getAllMessages(storeName);
    }

    public MessageInfo[] getPaginatedMessages(String storeName, int pageNo) throws RemoteException {
        return this.messageStoreAdminServiceStub.getPaginatedMessages(storeName, pageNo);
    }

    public String getEnvelope(String storeName, String messageId) throws RemoteException {
        return this.messageStoreAdminServiceStub.getEnvelope(storeName, messageId);
    }
}

