/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.registry;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.indexing.stub.generated.ContentSearchAdminServiceStub;
import org.wso2.carbon.registry.indexing.stub.generated.xsd.SearchResultsBean;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;
import org.wso2.esb.integration.common.clients.registry.SearchAdminServiceClient;

public class ContentSearchAdminClient {
    private static final Log log = LogFactory.getLog(SearchAdminServiceClient.class);
    private ContentSearchAdminServiceStub contentSearchAdminServiceStub;

    public ContentSearchAdminClient(String backEndUrl, String username, String password) throws AxisFault {
        String serviceName = "ContentSearchAdminService";
        String endPoint = backEndUrl + serviceName;
        this.contentSearchAdminServiceStub = new ContentSearchAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(username, password, (Stub)this.contentSearchAdminServiceStub);
    }

    public ContentSearchAdminClient(String sessionCookie, String backEndUrl) throws AxisFault {
        String serviceName = "ContentSearchAdminService";
        String endPoint = backEndUrl + serviceName;
        this.contentSearchAdminServiceStub = new ContentSearchAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.contentSearchAdminServiceStub);
    }

    public SearchResultsBean getContentSearchResults(String searchQuery) throws RemoteException {
        SearchResultsBean bean;
        try {
            bean = this.contentSearchAdminServiceStub.getContentSearchResults(searchQuery);
        }
        catch (RemoteException e) {
            String msg = "Unable o search the contents";
            log.error((Object)(msg + e));
            throw new RemoteException(msg, e);
        }
        return bean;
    }
}

