/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.secvault.cipher;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.secvault.MasterKey;
import org.wso2.carbon.secvault.SecureVaultUtils;
import org.wso2.carbon.secvault.exception.SecureVaultException;
import org.wso2.carbon.secvault.model.SecretRepositoryConfiguration;

public class JKSBasedCipherProvider {
    private static Logger logger = LoggerFactory.getLogger(JKSBasedCipherProvider.class);
    public static final String LOCATION = "keystoreLocation";
    public static final String ALIAS = "privateKeyAlias";
    public static final String KEY_STORE_PASSWORD = "keyStorePassword";
    public static final String PRIVATE_KEY_PASSWORD = "privateKeyPassword";
    private static final String JKS = "JKS";
    private Cipher encryptionCipher;
    private Cipher decryptionCipher;

    public void init(SecretRepositoryConfiguration secretRepositoryConfiguration, List<MasterKey> masterKeys) throws SecureVaultException {
        String keystoreLocation = secretRepositoryConfiguration.getParameter(LOCATION).orElseThrow(() -> new SecureVaultException("Key store location is mandatory"));
        String privateKeyAlias = secretRepositoryConfiguration.getParameter(ALIAS).orElseThrow(() -> new SecureVaultException("Private key alias is mandatory"));
        MasterKey keyStorePassword = SecureVaultUtils.getSecret(masterKeys, KEY_STORE_PASSWORD);
        MasterKey privateKeyPassword = SecureVaultUtils.getSecret(masterKeys, PRIVATE_KEY_PASSWORD);
        KeyStore keyStore = this.loadKeyStore(keystoreLocation, keyStorePassword.getMasterKeyValue().orElseThrow(() -> new SecureVaultException("Key store password is mandatory")));
        this.encryptionCipher = this.getEncryptionCipher(keyStore, privateKeyAlias);
        this.decryptionCipher = this.getDecryptionCipher(keyStore, privateKeyAlias, privateKeyPassword.getMasterKeyValue().orElseThrow(() -> new SecureVaultException("Private key password is mandatory")));
        logger.debug("JKSBasedCipherProvider initialized successfully.");
    }

    public byte[] encrypt(byte[] plainText) throws SecureVaultException {
        return this.doCipher(this.encryptionCipher, plainText);
    }

    public byte[] decrypt(byte[] cipherText) throws SecureVaultException {
        return this.doCipher(this.decryptionCipher, cipherText);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore loadKeyStore(String keyStorePath, char[] keyStorePassword) throws SecureVaultException {
        Path keyStoreFileLocation = Paths.get(keyStorePath, new String[0]).toAbsolutePath();
        try {
            Throwable throwable = null;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(keyStoreFileLocation.toString()));){
                KeyStore keyStore = KeyStore.getInstance(JKS);
                keyStore.load(bufferedInputStream, keyStorePassword);
                logger.debug("Keystore at path : '{}', loaded successfully.", (Object)keyStorePath);
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            catch (CertificateException e) {
                try {
                    throw new SecureVaultException("Failed to load certificates from keystore : '" + keyStorePath + "'", e);
                    catch (NoSuchAlgorithmException e2) {
                        throw new SecureVaultException("Failed to load keystore algorithm at : '" + keyStorePath + "'", e2);
                    }
                    catch (KeyStoreException e3) {
                        throw new SecureVaultException("Failed to initialize keystore at : '" + keyStorePath + "'", e3);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new SecureVaultException("Unable to find keystore at '" + keyStorePath + "'", e);
        }
    }

    private Cipher getEncryptionCipher(KeyStore keyStore, String alias) throws SecureVaultException {
        Certificate certificate;
        try {
            certificate = Optional.ofNullable(keyStore.getCertificate(alias)).orElseThrow(() -> new SecureVaultException("No certificate found with the given alias : " + alias));
        }
        catch (KeyStoreException e) {
            throw new SecureVaultException("Failed to get certificate for alias '" + alias + "'", e);
        }
        try {
            Cipher cipher = Cipher.getInstance(certificate.getPublicKey().getAlgorithm());
            cipher.init(1, certificate);
            logger.debug("Successfully created an encryption cipher with alias : '{}'", (Object)alias);
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new SecureVaultException("Failed to initialize Cipher for mode '1'", e);
        }
    }

    private Cipher getDecryptionCipher(KeyStore keyStore, String alias, char[] privateKeyPassword) throws SecureVaultException {
        PrivateKey privateKey;
        try {
            privateKey = Optional.ofNullable((PrivateKey)keyStore.getKey(alias, privateKeyPassword)).orElseThrow(() -> new SecureVaultException("No key found with the given alias : " + alias));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new SecureVaultException("Failed to get private key for alias '" + alias + "'", e);
        }
        try {
            Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
            cipher.init(2, privateKey);
            logger.debug("Successfully created a decryption cipher with alias : '{}'", (Object)alias);
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new SecureVaultException("Failed to initialize Cipher for mode '2'", e);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] doCipher(Cipher cipher, byte[] original) throws SecureVaultException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

