/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.ws.client.internal;

import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryProvider;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.ws.client.internal.WSClientDataHolder;
import org.wso2.carbon.registry.ws.client.registry.WSRegistryServiceClient;
import org.wso2.carbon.utils.ConfigurationContextService;

public class WSClientServiceComponent {
    private WSClientDataHolder dataHolder = WSClientDataHolder.getInstance();
    private static Log log = LogFactory.getLog(WSClientServiceComponent.class);
    private ServiceRegistration serviceRegistration = null;

    protected void activate(ComponentContext context) {
        RegistryProvider provider = new RegistryProvider(){
            private WSRegistryServiceClient client = null;
            private ScheduledExecutorService scheduledExecutor;

            public Registry getRegistry(String registryURL, String username, String password) throws RegistryException {
                if (this.client != null) {
                    return this.client;
                }
                if (registryURL != null && username != null && password != null) {
                    if (registryURL.endsWith("/")) {
                        registryURL = registryURL.substring(0, registryURL.length() - 1);
                    }
                    String serverURL = registryURL.substring(0, registryURL.indexOf("/registry")) + "/services/";
                    RegistryUtils.setTrustStoreSystemProperties();
                    this.client = new WSRegistryServiceClient(serverURL, username, password, WSClientServiceComponent.this.dataHolder.getConfigurationContext());
                    this.startExecutor(100000);
                    return this.client;
                }
                throw new RegistryException("Unable to create an instance of a WS Registry");
            }

            private void startExecutor(int timePeriod) {
                if (this.scheduledExecutor == null) {
                    this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
                    this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                        @Override
                        public void run() {
                            client = null;
                        }
                    }, timePeriod, timePeriod, TimeUnit.MILLISECONDS);
                }
            }
        };
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("type", "ws");
        this.serviceRegistration = context.getBundleContext().registerService(RegistryProvider.class.getName(), (Object)provider, ht);
        if (log.isDebugEnabled()) {
            log.info((Object)"Registry WS Client bundle is activated");
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        if (log.isDebugEnabled()) {
            log.info((Object)"Registry WS Client bundle is deactivated");
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.dataHolder.setConfigurationContext(contextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.dataHolder.setConfigurationContext(null);
    }
}

