/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.social.impl.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="social.component", immediate=true)
public class SocialDSComponent {
    private static Log log = LogFactory.getLog(SocialDSComponent.class);
    private static RealmService realmService = null;
    private static RegistryService registryService = null;

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Social Impl bundle is activated ");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Social Impl bundle is deactivated ");
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Realm Service");
        }
        SocialDSComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Realm Service");
        }
        SocialDSComponent.realmService = null;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Registry Service");
        }
        SocialDSComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Registry Service");
        }
        SocialDSComponent.registryService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static Registry getRegistry() throws RegistryException {
        return SocialDSComponent.getRegistryService().getConfigSystemRegistry();
    }

    public static UserStoreManager getUserStoreManager() throws RegistryException, UserStoreException {
        return SocialDSComponent.getRegistryService().getUserRealm(0).getUserStoreManager();
    }

    public static ClaimManager getClaimManager() throws RegistryException, UserStoreException {
        return SocialDSComponent.getRegistryService().getUserRealm(0).getClaimManager();
    }
}

