/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.beans.CollectionContentBean;
import org.wso2.carbon.registry.resource.beans.ContentBean;
import org.wso2.carbon.registry.resource.beans.ContentDownloadBean;
import org.wso2.carbon.registry.resource.download.DownloadManagerService;
import org.wso2.carbon.registry.resource.services.utils.GetDownloadContentUtil;
import org.wso2.carbon.registry.resource.services.utils.InputStreamBasedDataSource;
import org.wso2.carbon.utils.CarbonUtils;

public class ContentUtil {
    private static final Log log = LogFactory.getLog(ContentUtil.class);
    private static final String IMPORT_SCHEMA_LOCATION = "//xs:schema/xs:import[@schemaLocation]";
    private static final String INCLUDE_SCHEMA_LOCATION = "//xs:schema/xs:include[@schemaLocation]";
    private static DownloadManagerService downloadManagerService;

    public static void setDownloadManagerService(DownloadManagerService downloadManagerService) {
        ContentUtil.downloadManagerService = downloadManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollectionContentBean getCollectionContent(String path, UserRegistry registry) throws Exception {
        try {
            Resource resource = registry.get(path);
            if (!(resource instanceof Collection)) {
                String msg = "Attempted to get collection content from a non-collection resource " + path;
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
            }
            Collection collection = (Collection)resource;
            String[] childPaths = collection.getChildren();
            MessageContext messageContext = MessageContext.getCurrentMessageContext();
            if (messageContext != null && PaginationUtils.isPaginationHeadersExist((MessageContext)messageContext)) {
                String[] paginatedResult;
                int rowCount = childPaths.length;
                try {
                    PaginationUtils.setRowCount((MessageContext)messageContext, (String)Integer.toString(rowCount));
                    PaginationContext paginationContext = PaginationUtils.initPaginationContext((MessageContext)messageContext);
                    int start = paginationContext.getStart();
                    int count = paginationContext.getCount();
                    int startIndex = start == 1 ? 0 : start;
                    if (rowCount < start + count) {
                        paginatedResult = new String[rowCount - startIndex];
                        System.arraycopy(childPaths, startIndex, paginatedResult, 0, rowCount - startIndex);
                    } else {
                        paginatedResult = new String[count];
                        System.arraycopy(childPaths, startIndex, paginatedResult, 0, count);
                    }
                }
                finally {
                    PaginationContext.destroy();
                }
                childPaths = paginatedResult;
            }
            CollectionContentBean bean = new CollectionContentBean();
            bean.setChildPaths(childPaths);
            bean.setChildCount(childPaths.length);
            bean.setCollectionTypes(ContentUtil.getCollectionTypes());
            if (registry.getRegistryContext() != null) {
                List remoteInstances = registry.getRegistryContext().getRemoteInstances();
                String[] instances = new String[remoteInstances.size()];
                for (int i = 0; i < instances.length; ++i) {
                    instances[i] = ((RemoteConfiguration)remoteInstances.get(i)).getId();
                }
                bean.setRemoteInstances(instances);
            }
            ResourcePath resourcePath = new ResourcePath(path);
            bean.setPathWithVersion(resourcePath.getPathWithVersion());
            bean.setVersionView(!resourcePath.isCurrentVersion());
            return bean;
        }
        catch (Exception e) {
            String msg = "Failed to get content details of the resource " + path + ". Caused by: " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public static ResourceData[] getResourceData(String[] childPaths, UserRegistry registry) throws Exception {
        ArrayList<ResourceData> resourceDataList = new ArrayList<ResourceData>();
        for (String childPath : childPaths) {
            try {
                if (childPath == null || childPath.length() == 0) continue;
                Resource child = registry.get(childPath);
                ResourceData resourceData = new ResourceData();
                resourceData.setResourcePath(childPath);
                String[] parts = childPath.split("/");
                if (parts.length > 0) {
                    resourceData.setName(parts[parts.length - 1]);
                }
                resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
                resourceData.setAuthorUserName(child.getAuthorUserName());
                resourceData.setDescription(child.getDescription());
                resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
                Calendar createDateTime = Calendar.getInstance();
                createDateTime.setTime(child.getCreatedTime());
                resourceData.setCreatedOn(createDateTime);
                List mountPoints = child.getPropertyValues("registry.mountpoint");
                List targetPoints = child.getPropertyValues("registry.targetpoint");
                List actualPaths = child.getPropertyValues("registry.actualpath");
                String user = child.getProperty("registry.user");
                if (child.getProperty("registry.mount") != null) {
                    resourceData.setMounted(true);
                }
                if (child.getProperty("registry.link") != null) {
                    resourceData.setLink(true);
                    if (mountPoints != null && targetPoints != null) {
                        String tempPath = (String)actualPaths.get(0);
                        resourceData.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)tempPath, (UserRegistry)registry));
                        resourceData.setDeleteAllowed(UserUtil.isDeleteAllowed((String)registry.getUserName(), (String)tempPath, (UserRegistry)registry));
                        resourceData.setGetAllowed(UserUtil.isGetAllowed((String)registry.getUserName(), (String)tempPath, (UserRegistry)registry));
                        resourceData.setRealPath(tempPath);
                    } else if (user != null) {
                        resourceData.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                        resourceData.setDeleteAllowed(UserUtil.isDeleteAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                        resourceData.setGetAllowed(UserUtil.isGetAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                    }
                } else {
                    resourceData.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                    resourceData.setDeleteAllowed(UserUtil.isDeleteAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                    resourceData.setGetAllowed(UserUtil.isGetAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                }
                ContentUtil.calculateAverageStars(resourceData);
                if (child.getProperty("registry.externalLink") != null) {
                    resourceData.setExternalLink(true);
                }
                if (child.getProperty("registry.absent") != null) {
                    resourceData.setAbsent(child.getProperty("registry.absent"));
                }
                resourceDataList.add(resourceData);
            }
            catch (AuthorizationFailedException authorizationFailedException) {
                // empty catch block
            }
        }
        return resourceDataList.toArray(new ResourceData[resourceDataList.size()]);
    }

    public static ContentBean getContent(String path, UserRegistry registry) throws Exception {
        ResourcePath resourcePath = new ResourcePath(path);
        ContentBean bean = new ContentBean();
        Resource resource = registry.get(path);
        bean.setMediaType(resource.getMediaType());
        bean.setCollection(resource instanceof Collection);
        bean.setLoggedIn(!"wso2.anonymous.user".equals(registry.getUserName()));
        bean.setPathWithVersion(resourcePath.getPathWithVersion());
        bean.setAbsent(resource.getProperty("registry.absent"));
        List mountPoints = resource.getPropertyValues("registry.mountpoint");
        List targetPoints = resource.getPropertyValues("registry.targetpoint");
        List actualPaths = resource.getPropertyValues("registry.actualpath");
        String user = resource.getProperty("registry.user");
        if (resource.getProperty("registry.link") != null) {
            if (mountPoints != null && targetPoints != null) {
                String tempPath = (String)actualPaths.get(0);
                bean.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)tempPath, (UserRegistry)registry));
                bean.setRealPath(tempPath);
            } else if (user != null) {
                bean.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)path, (UserRegistry)registry));
            }
        } else {
            boolean putAllowed = UserUtil.isPutAllowed((String)registry.getUserName(), (String)path, (UserRegistry)registry);
            bean.setPutAllowed(putAllowed);
        }
        bean.setVersionView(!resourcePath.isCurrentVersion());
        bean.setContentPath(resourcePath.getCompletePath());
        resource.discard();
        return bean;
    }

    private static String[] getCollectionTypes() {
        return new String[]{"default", "Axis2 repository", "Synapse repository"};
    }

    private static void calculateAverageStars(ResourceData resourceData) {
        float tempRating = resourceData.getAverageRating() * 1000.0f;
        tempRating = Math.round(tempRating);
        resourceData.setAverageRating(tempRating /= 1000.0f);
        float averageRating = resourceData.getAverageRating();
        String[] averageStars = new String[5];
        for (int i = 0; i < 5; ++i) {
            float fraction;
            averageStars[i] = averageRating >= (float)(i + 1) ? "04" : (averageRating <= (float)i ? "00" : ((double)(fraction = averageRating - (float)i) <= 0.125 ? "00" : ((double)fraction > 0.125 && (double)fraction <= 0.375 ? "01" : ((double)fraction > 0.375 && (double)fraction <= 0.625 ? "02" : ((double)fraction > 0.625 && (double)fraction <= 0.875 ? "03" : "04")))));
        }
        resourceData.setAverageStars(averageStars);
    }

    public static boolean hasAssociations(String path, String type, UserRegistry registry) throws Exception {
        Association[] associations;
        if (type == null || path == null) {
            return false;
        }
        for (Association association : associations = registry.getAssociations(path, type)) {
            if (association.getAssociationType() == null || !association.getAssociationType().equals(type) || !association.getSourcePath().equals(path)) continue;
            return true;
        }
        return false;
    }

    public static ContentDownloadBean getContentWithDependencies(String path, UserRegistry registry) throws Exception {
        if (downloadManagerService != null) {
            return downloadManagerService.getDownloadContent(path, (Registry)registry);
        }
        return ContentUtil.getDownloadContent(path, (Registry)registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ContentDownloadBean getDownloadContent(String path, Registry _registry) throws Exception {
        ContentDownloadBean zipContent;
        File zipFile;
        File srcDir;
        block19: {
            ContentDownloadBean _fos2;
            block17: {
                UserRegistry registry = (UserRegistry)_registry;
                InputStream zipContentStream = null;
                srcDir = null;
                zipFile = null;
                String COLLECTION = "collection";
                ByteArrayOutputStream outputStream = null;
                try {
                    if (path == null) {
                        String msg = "Could not get the resource content. Path is not specified.";
                        log.error((Object)msg);
                        ContentDownloadBean contentDownloadBean = null;
                        return contentDownloadBean;
                    }
                    ContentDownloadBean bean = GetDownloadContentUtil.getContentDownloadBean(path, registry);
                    String zipDirPath = CarbonUtils.getCarbonHome() + File.separator + "tmp" + File.separator + bean.toString();
                    String zipDependencyPath = zipDirPath + File.separator + "dependencies";
                    String zipPath = zipDirPath + "-zip.zip";
                    Association[] associations = registry.getAssociations(path, "depends");
                    if (associations.length != 0) {
                        srcDir = new File(zipDirPath);
                        srcDir.mkdir();
                        new File(zipDependencyPath).mkdir();
                        zipFile = new File(zipPath);
                        File _tmp = new File(zipDirPath + File.separator + bean.getResourceName());
                        DataOutputStream _fos2 = new DataOutputStream(new FileOutputStream(_tmp));
                        byte[] _bytes = IOUtils.toByteArray((InputStream)bean.getContent().getInputStream());
                        ContentUtil.createDependencies(associations, registry, zipDependencyPath, path, COLLECTION, new String(_bytes), _fos2, true);
                        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
                        ContentUtil.zipDir(zipDirPath, zos);
                        zos.close();
                        zipContentStream = new FileInputStream(new File(zipPath));
                    } else {
                        if (bean.getContent() == null) {
                            String msg = "The resource content was empty.";
                            log.error((Object)msg);
                            _fos2 = null;
                            FileUtils.deleteQuietly((File)srcDir);
                            break block17;
                        }
                        zipContentStream = bean.getContent().getInputStream();
                    }
                    if (zipContentStream != null) {
                        try {
                            int byteCount;
                            outputStream = new ByteArrayOutputStream();
                            byte[] contentChunk = new byte[1024];
                            while ((byteCount = zipContentStream.read(contentChunk)) != -1) {
                                outputStream.write(contentChunk, 0, byteCount);
                            }
                            outputStream.flush();
                        }
                        finally {
                            zipContentStream.close();
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                    }
                    zipContent = new ContentDownloadBean();
                    InputStreamBasedDataSource contentSource = new InputStreamBasedDataSource(new ByteArrayInputStream(outputStream.toByteArray()));
                    DataHandler content = new DataHandler((DataSource)contentSource);
                    zipContent.setContent(content);
                    FileUtils.deleteQuietly((File)srcDir);
                    break block19;
                }
                catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
                    String msg = "Failed to get resource content. " + e.getMessage();
                    log.error((Object)msg, (Throwable)e);
                    ContentDownloadBean contentDownloadBean = null;
                    return contentDownloadBean;
                }
            }
            FileUtils.deleteQuietly(zipFile);
            return _fos2;
        }
        FileUtils.deleteQuietly((File)zipFile);
        return zipContent;
        finally {
            FileUtils.deleteQuietly(srcDir);
            FileUtils.deleteQuietly(zipFile);
        }
    }

    private static void createDependencies(Association[] associations, UserRegistry registry, String zipDependencyPath, String scrPath, String COLLECTION, String content, DataOutputStream srcOutputStream, boolean isMasterArtifact) throws Exception {
        for (Association associationBean : associations) {
            if (!ContentUtil.isADependency(associationBean, registry, scrPath, COLLECTION)) continue;
            ContentDownloadBean dependencyBean = GetDownloadContentUtil.getContentDownloadBean(associationBean.getDestinationPath(), registry);
            InputStream dependencyContentStream = dependencyBean.getContent().getInputStream();
            File tmp = new File(zipDependencyPath + File.separator + dependencyBean.getResourceName());
            DataOutputStream fos = new DataOutputStream(new FileOutputStream(tmp));
            byte[] bytes = IOUtils.toByteArray((InputStream)dependencyContentStream);
            ContentUtil.createDependencies(registry.getAssociations(associationBean.getDestinationPath(), "depends"), registry, zipDependencyPath, associationBean.getDestinationPath(), COLLECTION, new String(bytes), fos, false);
        }
        if (scrPath.endsWith(".wsdl") || scrPath.endsWith(".xsd")) {
            OMElement srcOMElement = AXIOMUtil.stringToOM((String)content);
            ContentUtil.updateSchemaImports(srcOMElement, isMasterArtifact, IMPORT_SCHEMA_LOCATION);
            ContentUtil.updateSchemaImports(srcOMElement, isMasterArtifact, INCLUDE_SCHEMA_LOCATION);
            ContentUtil.updateWSDLImports(srcOMElement, isMasterArtifact);
            IOUtils.write((byte[])srcOMElement.toString().getBytes(), (OutputStream)srcOutputStream);
        } else {
            IOUtils.write((byte[])content.getBytes(), (OutputStream)srcOutputStream);
        }
    }

    private static boolean isADependency(Association associationBean, UserRegistry registry, String scrPath, String COLLECTION) throws Exception {
        if (associationBean.getDestinationPath() == null || !registry.resourceExists(associationBean.getDestinationPath())) {
            return false;
        }
        ResourceData resourceData = ContentUtil.getResourceData(new String[]{associationBean.getDestinationPath()}, registry)[0];
        boolean isCollection = resourceData.getResourceType().equals(COLLECTION);
        return associationBean.getAssociationType() != null && associationBean.getAssociationType().equals("depends") && associationBean.getSourcePath().equals(scrPath) && !isCollection;
    }

    private static OMElement updateSchemaImports(OMElement omElement, boolean isMasterArtifact, String xpath) throws JaxenException {
        AXIOMXPath xPath = new AXIOMXPath(xpath);
        xPath.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        Object result = xPath.evaluate((Object)omElement);
        if (!(result instanceof ArrayList)) {
            return omElement;
        }
        ArrayList list = (ArrayList)result;
        for (Object obj : list) {
            OMElement _import = (OMElement)obj;
            OMAttribute attribute = _import.getAttribute(new QName("schemaLocation"));
            String newValue = isMasterArtifact ? "dependencies" + attribute.getAttributeValue().substring(attribute.getAttributeValue().lastIndexOf("/")) : attribute.getAttributeValue().substring(attribute.getAttributeValue().lastIndexOf("/") + 1);
            attribute.setAttributeValue(newValue);
        }
        return omElement;
    }

    private static OMElement updateWSDLImports(OMElement omElement, boolean isMasterArtifact) throws JaxenException {
        AXIOMXPath xPath = new AXIOMXPath("//wsd:import[@location]");
        xPath.addNamespace("wsd", "http://schemas.xmlsoap.org/wsdl/");
        Object result = xPath.evaluate((Object)omElement);
        if (!(result instanceof ArrayList)) {
            return omElement;
        }
        ArrayList list = (ArrayList)result;
        for (Object obj : list) {
            OMElement _import = (OMElement)obj;
            OMAttribute attribute = _import.getAttribute(new QName("location"));
            String newValue = isMasterArtifact ? "dependencies" + attribute.getAttributeValue().substring(attribute.getAttributeValue().lastIndexOf("/")) : attribute.getAttributeValue().substring(attribute.getAttributeValue().lastIndexOf("/") + 1);
            attribute.setAttributeValue(newValue);
        }
        return omElement;
    }

    private static void zipDir(String dirToZip, ZipOutputStream zos) throws RegistryException {
        try {
            File zipDir = new File(dirToZip);
            String[] dirList = zipDir.list();
            byte[] readBuffer = new byte[1024];
            int bytesIn = 0;
            for (int i = 0; i < dirList.length; ++i) {
                File f = new File(zipDir, dirList[i]);
                if (f.isDirectory()) {
                    ContentUtil.zipDir(f.getPath(), zos);
                    continue;
                }
                FileInputStream fis = new FileInputStream(f.getPath());
                ZipEntry anEntry = new ZipEntry(f.getPath().contains("dependencies") ? "dependencies" + File.separator + f.getName() : f.getName());
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
                zos.flush();
                fis.close();
            }
        }
        catch (Exception e) {
            throw new RegistryException("Error occurred while zipping the file");
        }
    }

    public static String sanitizeFilename(String filename) {
        return filename.replaceAll("[:\\\\/*\"?|<>]", "_");
    }
}

