/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.apache.commons.io.FileUtils;
import org.wso2.carbon.registry.admin.api.resource.IResourceService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.common.utils.RegistryUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.resource.beans.CollectionContentBean;
import org.wso2.carbon.registry.resource.beans.ContentBean;
import org.wso2.carbon.registry.resource.beans.ContentDownloadBean;
import org.wso2.carbon.registry.resource.beans.MetadataBean;
import org.wso2.carbon.registry.resource.beans.PermissionBean;
import org.wso2.carbon.registry.resource.beans.ResourceTreeEntryBean;
import org.wso2.carbon.registry.resource.beans.VersionsBean;
import org.wso2.carbon.registry.resource.internal.ResourceDataHolder;
import org.wso2.carbon.registry.resource.services.utils.AddCollectionUtil;
import org.wso2.carbon.registry.resource.services.utils.AddRemoteLinkUtil;
import org.wso2.carbon.registry.resource.services.utils.AddResourceUtil;
import org.wso2.carbon.registry.resource.services.utils.AddRolePermissionUtil;
import org.wso2.carbon.registry.resource.services.utils.AddSymbolicLinkUtil;
import org.wso2.carbon.registry.resource.services.utils.AddTextResourceUtil;
import org.wso2.carbon.registry.resource.services.utils.ChangeRolePermissionsUtil;
import org.wso2.carbon.registry.resource.services.utils.ContentUtil;
import org.wso2.carbon.registry.resource.services.utils.CopyResourceUtil;
import org.wso2.carbon.registry.resource.services.utils.CreateVersionUtil;
import org.wso2.carbon.registry.resource.services.utils.DeleteUtil;
import org.wso2.carbon.registry.resource.services.utils.DeleteVersionUtil;
import org.wso2.carbon.registry.resource.services.utils.DescriptionUtil;
import org.wso2.carbon.registry.resource.services.utils.GetDownloadContentUtil;
import org.wso2.carbon.registry.resource.services.utils.GetPropertyUtil;
import org.wso2.carbon.registry.resource.services.utils.GetResourceTreeEntryUtil;
import org.wso2.carbon.registry.resource.services.utils.GetTextContentUtil;
import org.wso2.carbon.registry.resource.services.utils.GetVersionsUtil;
import org.wso2.carbon.registry.resource.services.utils.MediaTypeUtil;
import org.wso2.carbon.registry.resource.services.utils.MetadataPopulator;
import org.wso2.carbon.registry.resource.services.utils.MoveResourceUtil;
import org.wso2.carbon.registry.resource.services.utils.PermissionUtil;
import org.wso2.carbon.registry.resource.services.utils.RenameResourceUtil;
import org.wso2.carbon.registry.resource.services.utils.ResourceServiceException;
import org.wso2.carbon.registry.resource.services.utils.RestoreVersionUtil;
import org.wso2.carbon.registry.resource.services.utils.UpdateTextContentUtil;

public class ResourceService
extends RegistryAbstractAdmin
implements IResourceService<MetadataBean, CollectionContentBean, ResourceData, ContentBean, PermissionBean, VersionsBean, ResourceTreeEntryBean, ContentDownloadBean> {
    public MetadataBean getMetadata(String path) throws Exception {
        RegistryUtil.setSessionResourcePath((String)path);
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return MetadataPopulator.populate(path, registry);
    }

    public void setDescription(String path, String description) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return;
        }
        DescriptionUtil.setDescription(registry, path, description);
    }

    public void updateMediaType(String path, String mediaType) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return;
        }
        MediaTypeUtil.updateMediaType(registry, path, mediaType);
    }

    public CollectionContentBean getCollectionContent(String path) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return ContentUtil.getCollectionContent(path, registry);
    }

    public ResourceData[] getResourceData(String[] paths) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return ContentUtil.getResourceData(paths, registry);
    }

    public ContentBean getContentBean(String path) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return ContentUtil.getContent(path, registry);
    }

    public String addCollection(String parentPath, String collectionName, String mediaType, String description) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return null;
        }
        return AddCollectionUtil.process(parentPath, collectionName, mediaType, description, registry);
    }

    public boolean addTextResource(String parentPath, String fileName, String mediaType, String description, String content) throws Exception {
        return this.addTextContent(parentPath, fileName, mediaType, description, content);
    }

    public boolean addTextContent(String parentPath, String fileName, String mediaType, String description, String content) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry(ResourceDataHolder.getInstance().getRegistryService());
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        AddTextResourceUtil.addTextResource(parentPath, fileName, mediaType, description, content, registry);
        return true;
    }

    public void addSymbolicLink(String parentPath, String name, String targetPath) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return;
        }
        AddSymbolicLinkUtil.addSymbolicLink(registry, parentPath, name, targetPath);
    }

    public void addRemoteLink(String parentPath, String name, String instance, String targetPath) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return;
        }
        AddRemoteLinkUtil.addRemoteLink(registry, parentPath, name, instance, targetPath);
    }

    public boolean delete(String pathToDelete) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        DeleteUtil.process(pathToDelete, registry);
        return true;
    }

    public PermissionBean getPermissions(String path) throws Exception {
        try {
            return PermissionUtil.getPermissions((UserRegistry)this.getRootRegistry(), path);
        }
        catch (Exception e) {
            throw new ResourceServiceException(e.getMessage(), e);
        }
    }

    public boolean addUserPermission(String pathToAuthorize, String userToAuthorize, String actionToAuthorize, String permissionType) throws ResourceServiceException {
        throw new UnsupportedOperationException("This operation is no longer supported");
    }

    public boolean addRolePermission(String pathToAuthorize, String roleToAuthorize, String actionToAuthorize, String permissionType) throws ResourceServiceException {
        try {
            AddRolePermissionUtil.addRolePermission((UserRegistry)this.getRootRegistry(), pathToAuthorize, roleToAuthorize, actionToAuthorize, permissionType);
            this.setPermissionUpdateTimestamp();
        }
        catch (Exception e) {
            throw new ResourceServiceException(e.getMessage(), e);
        }
        return true;
    }

    public boolean changeUserPermissions(String resourcePath, String permissionInput) throws Exception {
        throw new UnsupportedOperationException("This operation is no longer supported");
    }

    public boolean changeRolePermissions(String resourcePath, String permissionsInput) throws Exception {
        try {
            ChangeRolePermissionsUtil.changeRolePermissions((UserRegistry)this.getRootRegistry(), resourcePath, permissionsInput);
            this.setPermissionUpdateTimestamp();
        }
        catch (Exception e) {
            throw new ResourceServiceException(e.getMessage(), e);
        }
        return true;
    }

    public String getTextContent(String path) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return GetTextContentUtil.getTextContent(path, (Registry)registry);
    }

    public boolean updateTextContent(String resourcePath, String contentText) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        UpdateTextContentUtil.updateTextContent(resourcePath, contentText, (Registry)registry);
        return true;
    }

    public boolean addResource(String path, String mediaType, String description, DataHandler content, String symlinkLocation, String[][] properties) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry(ResourceDataHolder.getInstance().getRegistryService());
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        AddResourceUtil.addResource(path, mediaType, description, content, symlinkLocation, (Registry)registry, properties);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addExtension(String name, DataHandler content) throws Exception {
        String sanitizedFilename = ContentUtil.sanitizeFilename(name);
        File extension = new File(RegistryUtils.getExtensionLibDirectoryPath() + File.separator + sanitizedFilename);
        File extensionsDirectory = extension.getParentFile();
        if (extensionsDirectory.exists() || extensionsDirectory.mkdir()) {
            try (FileOutputStream os = new FileOutputStream(extension);){
                content.writeTo((OutputStream)os);
            }
        }
        return true;
    }

    public String[] listExtensions() throws Exception {
        String[] names;
        File extensionsDirectory = new File(RegistryUtils.getExtensionLibDirectoryPath());
        if (extensionsDirectory.exists() && (names = extensionsDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.endsWith(".jar");
            }
        })) != null && names.length > 0) {
            return names;
        }
        return new String[0];
    }

    public boolean removeExtension(String name) throws Exception {
        File extension = new File(RegistryUtils.getExtensionLibDirectoryPath() + File.separator + name);
        FileUtils.forceDelete((File)extension);
        return true;
    }

    public boolean renameResource(String parentPath, String oldResourcePath, String newResourceName) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        RenameResourceUtil.renameResource(parentPath, oldResourcePath, newResourceName, registry);
        return true;
    }

    public boolean copyResource(String parentPath, String oldResourcePath, String destinationPath, String resourceName) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        CopyResourceUtil.copyResource(registry, parentPath, oldResourcePath, destinationPath, resourceName);
        return true;
    }

    public boolean moveResource(String parentPath, String oldResourcePath, String destinationPath, String resourceName) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        MoveResourceUtil.moveResource(registry, parentPath, oldResourcePath, destinationPath, resourceName);
        return true;
    }

    public String getSessionResourcePath() throws Exception {
        return RegistryUtil.getSessionResourcePath();
    }

    public void setSessionResourcePath(String resourcePath) throws Exception {
        RegistryUtil.setSessionResourcePath((String)resourcePath);
    }

    public ResourceTreeEntryBean getResourceTreeEntry(String resourcePath) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return GetResourceTreeEntryUtil.getResourceTreeEntry(resourcePath, registry);
    }

    public boolean createVersion(String resourcePath) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        CreateVersionUtil.createVersion(registry, resourcePath);
        return true;
    }

    public boolean restoreVersion(String versionPath) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        RestoreVersionUtil.restoreVersion(registry, versionPath);
        return true;
    }

    public VersionsBean getVersionsBean(String path) throws Exception {
        return GetVersionsUtil.getVersionsBean((UserRegistry)this.getRootRegistry(), path);
    }

    public String getMediatypeDefinitions() throws Exception {
        Registry configSystemRegistry = this.getConfigSystemRegistry();
        return MediaTypesUtils.getResourceMediaTypeMappings((Registry)configSystemRegistry);
    }

    public String getCollectionMediatypeDefinitions() throws Exception {
        Registry configSystemRegistry = this.getConfigSystemRegistry();
        return MediaTypesUtils.getCollectionMediaTypeMappings((Registry)configSystemRegistry);
    }

    public String getCustomUIMediatypeDefinitions() throws Exception {
        Registry configSystemRegistry = this.getConfigSystemRegistry();
        return MediaTypesUtils.getCustomUIMediaTypeMappings((Registry)configSystemRegistry);
    }

    public String getProperty(String resourcePath, String key) throws Exception {
        return GetPropertyUtil.getProperty((UserRegistry)this.getRootRegistry(), resourcePath, key);
    }

    public ContentDownloadBean getContentDownloadBean(String path) throws Exception {
        UserRegistry userRegistry = (UserRegistry)this.getRootRegistry();
        return GetDownloadContentUtil.getContentDownloadBean(path, userRegistry);
    }

    public String getHumanReadableMediaTypes() throws Exception {
        return MediaTypesUtils.getAllHumanTypes();
    }

    public String getMimeTypeFromHuman(String mediaType) throws Exception {
        return MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)mediaType);
    }

    public boolean deleteVersionHistory(String path, String snapshotId) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        long snapshotID = Long.parseLong(snapshotId);
        DeleteVersionUtil.process(path, snapshotID, registry);
        return true;
    }

    public ContentDownloadBean getZipWithDependencies(String path) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return ContentUtil.getContentWithDependencies(path, registry);
    }

    public boolean hasAssociations(String path, String type) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return ContentUtil.hasAssociations(path, type, registry);
    }
}

