/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.util.ArrayList;
import java.util.Date;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.common.WebResourcePath;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.beans.MetadataBean;
import org.wso2.carbon.user.core.AuthorizationManager;

public class MetadataPopulator {
    public static MetadataBean populate(String purePath, UserRegistry registry) throws Exception {
        ResourcePath path = new ResourcePath(purePath);
        Resource resource = registry.get(path.getPathWithVersion());
        MetadataBean bean = new MetadataBean();
        bean.setAuthor(resource.getAuthorUserName());
        bean.setCollection(resource instanceof Collection);
        bean.setDescription(resource.getDescription());
        bean.setLastUpdater(resource.getLastUpdaterUserName());
        bean.setMediaType(resource.getMediaType());
        bean.setPath(resource.getPath());
        bean.setFormattedCreatedOn(CommonUtil.formatDate((Date)resource.getCreatedTime()));
        bean.setFormattedLastModified(CommonUtil.formatDate((Date)resource.getLastModified()));
        if (CarbonContext.getThreadLocalCarbonContext().getUsername() != null && !CarbonContext.getThreadLocalCarbonContext().getUsername().equals(resource.getProperty("registry.retention.user.name")) && Boolean.parseBoolean(resource.getProperty("registry.retention.writeLocked"))) {
            bean.setWriteLocked(resource.getProperty("registry.retention.writeLocked"));
            bean.setDeleteLocked(resource.getProperty("registry.retention.deleteLocked"));
        } else {
            bean.setWriteLocked("false");
            bean.setDeleteLocked("false");
        }
        if (resource instanceof CollectionImpl) {
            bean.setResourceVersion(String.valueOf(((CollectionImpl)resource).getVersionNumber()));
        } else {
            bean.setResourceVersion(String.valueOf(((ResourceImpl)resource).getVersionNumber()));
        }
        bean.setActiveResourcePath(path.getPath());
        if (path.parameterExists("version")) {
            bean.setVersionView(true);
            bean.setPermalink(path.getCompletePath());
        } else {
            bean.setVersionView(false);
            bean.setPermalink(resource.getPermanentPath());
        }
        if (resource.getProperty("registry.link") != null || resource.getProperty("registry.mount") != null) {
            bean.setPermalink("hide");
        }
        bean.setNavigatablePaths(MetadataPopulator.constructNavigatablePaths(path.getCompletePath()));
        bean.setContentPath(path.getCompletePath());
        bean.setServerBaseURL("carbon registry base URL.");
        String versionPath = path.parameterExists("version") ? path.getPath() + ";" + "version" + ":" + path.getParameterValue("version") : path.getPath();
        bean.setPathWithVersion(versionPath);
        String userName = registry.getUserName();
        AuthorizationManager authorizer = registry.getUserRealm().getAuthorizationManager();
        boolean putAllowed = authorizer.isUserAuthorized(userName, path.getPath(), "http://www.wso2.org/projects/registry/actions/add");
        bean.setPutAllowed(putAllowed);
        return bean;
    }

    private static WebResourcePath[] constructNavigatablePaths(String rawPath) {
        ArrayList<WebResourcePath> navigatablePaths = new ArrayList<WebResourcePath>();
        if (rawPath.equals("/")) {
            WebResourcePath webPath = new WebResourcePath();
            webPath.setNavigateName("/");
            webPath.setNavigatePath("#");
            navigatablePaths.add(webPath);
        } else {
            WebResourcePath rootPath = new WebResourcePath();
            rootPath.setNavigateName("/");
            rootPath.setNavigatePath("/");
            navigatablePaths.add(rootPath);
            String preparedPath = rawPath;
            if (preparedPath.startsWith("/")) {
                preparedPath = preparedPath.substring("/".length());
            }
            if (preparedPath.endsWith("/")) {
                preparedPath = preparedPath.substring(0, preparedPath.length() - "/".length());
            }
            String[] parts = preparedPath.split("/");
            for (int i = 0; i < parts.length; ++i) {
                WebResourcePath resourcePath = new WebResourcePath();
                if (i == parts.length - 1) {
                    String[] q = parts[i].split(";");
                    if (q.length == 2) {
                        if (q[1].startsWith("version:")) {
                            String versionNumber = q[1].substring("version:".length());
                            String navName = q[0] + " (version " + versionNumber + ")";
                            resourcePath.setNavigateName(navName);
                        } else {
                            resourcePath.setNavigateName(parts[i]);
                        }
                    } else {
                        resourcePath.setNavigateName(parts[i]);
                    }
                } else {
                    resourcePath.setNavigateName(parts[i]);
                }
                StringBuffer tempPath = new StringBuffer();
                for (int j = 0; j < i + 1; ++j) {
                    tempPath.append("/").append(parts[j]);
                }
                resourcePath.setNavigatePath(tempPath.toString());
                navigatablePaths.add(resourcePath);
            }
        }
        return navigatablePaths.toArray(new WebResourcePath[navigatablePaths.size()]);
    }
}

