/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class AddCollectionUtil {
    private static final Log log = LogFactory.getLog(AddCollectionUtil.class);

    public static String process(String parentPath, String collectionName, String mediaType, String description, UserRegistry registry) throws RegistryException {
        while (collectionName != null && collectionName.startsWith("/")) {
            collectionName = collectionName.substring("/".length());
        }
        String path = parentPath.equals("/") ? "/" + collectionName : parentPath + "/" + collectionName;
        CollectionImpl collection = null;
        try {
            collection = (CollectionImpl)registry.newCollection();
        }
        catch (RegistryException e) {
            String msg = "Failed to create new collection instance for the collection " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        collection.setPath(path);
        if (!mediaType.equals("default")) {
            collection.setMediaType(mediaType);
        }
        collection.setDescription(description);
        try {
            registry.put(path, (Resource)collection);
        }
        catch (RegistryException e) {
            String msg = "Failed to add collection " + path + ". " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return parentPath;
    }
}

