/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.beans.VersionPath;
import org.wso2.carbon.registry.resource.beans.VersionsBean;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;

public class GetVersionsUtil {
    private static final Log log = LogFactory.getLog(GetVersionsUtil.class);

    public static VersionsBean getVersionsBean(UserRegistry userRegistry, String path) throws Exception {
        VersionsBean versionsBean = new VersionsBean();
        versionsBean.setResourcePath(path);
        try {
            Resource currentResource = userRegistry.get(path);
            if (currentResource != null) {
                String isLink = currentResource.getProperty("registry.link");
                String mountPoint = currentResource.getProperty("registry.mountpoint");
                String[] targetPoint = currentResource.getProperty("registry.targetpoint");
                String actualPath = currentResource.getProperty("registry.actualpath");
                if (CarbonContext.getThreadLocalCarbonContext().getUsername() != null && !CarbonContext.getThreadLocalCarbonContext().getUsername().equals(currentResource.getProperty("registry.retention.user.name")) && Boolean.parseBoolean(currentResource.getProperty("registry.retention.writeLocked"))) {
                    versionsBean.setWriteLocked(currentResource.getProperty("registry.retention.writeLocked"));
                    versionsBean.setDeleteLocked(currentResource.getProperty("registry.retention.deleteLocked"));
                } else {
                    versionsBean.setWriteLocked("false");
                    versionsBean.setDeleteLocked("false");
                }
                if (isLink != null && mountPoint != null && targetPoint != null) {
                    currentResource = userRegistry.get(actualPath);
                }
            }
            if (currentResource != null) {
                versionsBean.setPermalink(currentResource.getPermanentPath());
                currentResource.discard();
            }
            String[] versions = userRegistry.getVersions(path);
            ArrayList<VersionPath> versionPaths = new ArrayList<VersionPath>();
            for (String version : versions) {
                Resource versionResource;
                VersionPath versionPath = new VersionPath();
                versionPath.setCompleteVersionPath(version);
                versionPath.setActiveResourcePath(path);
                ResourcePath resourcePath = new ResourcePath(version);
                if (!resourcePath.isCurrentVersion()) {
                    long versionNumber = Long.parseLong(resourcePath.getParameterValue("version"));
                    versionPath.setVersionNumber(versionNumber);
                }
                if ((versionResource = userRegistry.get(version)) != null) {
                    versionPath.setUpdater(versionResource.getLastUpdaterUserName());
                    Calendar versionLastModified = Calendar.getInstance();
                    versionLastModified.setTime(versionResource.getLastModified());
                    versionPath.setUpdatedOn(versionLastModified);
                    versionResource.discard();
                }
                versionPaths.add(versionPath);
            }
            versionsBean.setVersionPaths(versionPaths.toArray(new VersionPath[versionPaths.size()]));
            String userName = userRegistry.getUserName();
            versionsBean.setLoggedIn(!"wso2.anonymous.user".equals(userName));
            ResourcePath resourcePath = new ResourcePath(path);
            try {
                AuthorizationManager authorizer = userRegistry.getUserRealm().getAuthorizationManager();
                boolean putAllowed = authorizer.isUserAuthorized(userName, resourcePath.getPath(), "http://www.wso2.org/projects/registry/actions/add");
                boolean deleteAllowed = authorizer.isUserAuthorized(userName, resourcePath.getPath(), "http://www.wso2.org/projects/registry/actions/delete");
                versionsBean.setPutAllowed(putAllowed);
                versionsBean.setDeletePermissionAllowed(deleteAllowed);
            }
            catch (UserStoreException e) {
                String msg = "Failed to check put permissions of user " + userName + " on the resource " + path + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to get version information of resource " + path + ". " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return versionsBean;
    }
}

