/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class GetTextContentUtil {
    private static final Log log = LogFactory.getLog(GetTextContentUtil.class);
    private static final String URL_SOURCE_REGEX = "(http|https|ftp|file)://[^\\s]*?.*";
    private static final String ENCODING = System.getProperty("carbon.registry.character.encoding");
    private static final String DECODE_TYPE = "text/plain; charset=UTF-8";

    public static String getTextContent(String path, Registry registry) throws Exception {
        try {
            if (path != null && path.contains("..")) {
                path = FilenameUtils.normalize((String)path);
            }
            Resource resource = registry.get(path);
            byte[] content = (byte[])resource.getContent();
            String contentString = "";
            if (content != null) {
                contentString = RegistryUtils.decodeBytes((byte[])content);
            }
            resource.discard();
            return contentString;
        }
        catch (RegistryException e) {
            String msg = "Could not get the content of the resource " + path + ". Caused by: " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static DataHandler getByteContent(String fetchURL) throws RegistryException {
        StringBuilder sb = new StringBuilder();
        DataHandler handler = null;
        BufferedReader in = null;
        if (fetchURL.matches(URL_SOURCE_REGEX)) {
            try {
                String inputLine;
                URL sourceURL = new URL(fetchURL);
                URLConnection connection = sourceURL.openConnection();
                connection.setRequestProperty("User-Agent", "");
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    sb.append(inputLine);
                }
                ByteArrayDataSource ds = new ByteArrayDataSource(GetTextContentUtil.encodeString(sb.toString()), DECODE_TYPE);
                handler = new DataHandler((DataSource)ds);
            }
            catch (IOException e) {
                String msg = "Wrong or unavailable source URL " + fetchURL + ".";
                throw new RegistryException(msg, (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        String msg = "Error occurred while trying to close the BufferedReader";
                        log.warn((Object)msg, (Throwable)e);
                    }
                }
            }
        }
        String msg = "Invalid source URL format " + fetchURL + ".";
        log.error((Object)msg);
        throw new RegistryException(msg);
        return handler;
    }

    private static byte[] encodeString(String content) throws RegistryException {
        byte[] bytes;
        try {
            bytes = ENCODING == null ? content.getBytes() : content.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            String msg = ENCODING + " is unsupported encoding type";
            throw new RegistryException(msg, (Throwable)e);
        }
        return bytes;
    }
}

