/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class ResourceServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(ResourceServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            UserRegistry registry = (UserRegistry)request.getSession().getAttribute("WSO2RegistryRoot");
            String path = request.getParameter("path");
            if (path == null) {
                String msg = "Could not get the resource content. Path is not specified.";
                log.error((Object)msg);
                response.setStatus(400);
                return;
            }
            Resource resource = null;
            try {
                resource = registry.get(path);
            }
            catch (RegistryException e) {
                String msg = "Error retrieving the resource " + path + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw e;
            }
            if (resource instanceof Collection) {
                String msg = "Could not get the resource content. Path " + path + " refers to a collection.";
                log.error((Object)msg);
                response.setStatus(501);
                return;
            }
            response.setDateHeader("Last-Modified", resource.getLastModified().getTime());
            if (resource.getMediaType() != null && resource.getMediaType().length() > 0) {
                response.setContentType(resource.getMediaType());
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=" + RegistryUtils.getResourceName((String)path));
                response.setContentType("application/download");
            }
            InputStream contentStream = resource.getContentStream();
            if (contentStream != null) {
                try {
                    int byteCount;
                    ServletOutputStream servletOutputStream = response.getOutputStream();
                    byte[] contentChunk = new byte[1024];
                    while ((byteCount = contentStream.read(contentChunk)) != -1) {
                        servletOutputStream.write(contentChunk, 0, byteCount);
                    }
                    response.flushBuffer();
                    servletOutputStream.flush();
                }
                finally {
                    contentStream.close();
                }
            } else {
                Object content = resource.getContent();
                if (content != null) {
                    if (content instanceof byte[]) {
                        ServletOutputStream servletOutputStream = response.getOutputStream();
                        servletOutputStream.write((byte[])content);
                        response.flushBuffer();
                        servletOutputStream.flush();
                    } else {
                        PrintWriter writer = response.getWriter();
                        writer.write(content.toString());
                        writer.flush();
                    }
                }
            }
            resource.discard();
        }
        catch (RegistryException e) {
            String msg = "Failed to get resource content. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            response.setStatus(500);
            return;
        }
    }
}

