/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.services.utils.AddTextResourceUtil;

public class AddSymbolicLinkUtil {
    private static final Log log = LogFactory.getLog(AddTextResourceUtil.class);

    public static void addSymbolicLink(UserRegistry userRegistry, String parentPath, String name, String targetPath) throws Exception {
        String linkResourcePath = "/".equals(parentPath) ? "/" + name : parentPath + "/" + name;
        if ("/".equals(targetPath)) {
            String msg = "Unable to create symbolic link to root.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        try {
            userRegistry.createLink(linkResourcePath, targetPath);
        }
        catch (RegistryException e) {
            String msg = "Failed to add symbolic link to path " + linkResourcePath + ". " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

