/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class MoveResourceUtil {
    private static final Log log = LogFactory.getLog(MoveResourceUtil.class);

    public static void moveResource(UserRegistry registry, String parentPath, String oldResourcePath, String destinationPath, String resourceName) throws Exception {
        if (!destinationPath.startsWith("/")) {
            destinationPath = "/" + destinationPath;
        }
        String newResourcePath = destinationPath.endsWith("/") ? destinationPath + resourceName : destinationPath + "/" + resourceName;
        try {
            if (registry.resourceExists(destinationPath) && !(registry.get(destinationPath) instanceof CollectionImpl)) {
                throw new RegistryException("A resource can't be moved to a resource");
            }
            registry.move(oldResourcePath, newResourcePath);
        }
        catch (RegistryException e) {
            String msg = "Failed to move the resource: " + oldResourcePath + " to Destination: " + newResourcePath + ". Caused by: " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

