/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class GetPropertyUtil {
    private static final Log log = LogFactory.getLog(GetPropertyUtil.class);

    public static String getProperty(UserRegistry registry, String resourcePath, String key) throws RegistryException {
        try {
            Resource resource;
            if (registry.resourceExists(resourcePath) && (resource = registry.get(resourcePath)) != null) {
                String value = resource.getProperty(key);
                resource.discard();
                return value;
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to get the resource information of resource " + resourcePath + " for retrieving a property with key : " + key + ". Error :" + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return "";
    }
}

