/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ImportResourceUtil {
    private static final Log log = LogFactory.getLog(ImportResourceUtil.class);

    public static String importResource(String parentPath, String resourceName, String mediaType, String description, String fetchURL, String symlinkLocation, UserRegistry userRegistry, String[][] properties) throws Exception {
        String resourcePath = "/".equals(parentPath) ? "/" + resourceName : parentPath + "/" + resourceName;
        try {
            Resource metadataResource = userRegistry.newResource();
            metadataResource.setMediaType(mediaType);
            metadataResource.setDescription(description);
            if (symlinkLocation != null) {
                if (!symlinkLocation.endsWith("/")) {
                    symlinkLocation = symlinkLocation + "/";
                }
                metadataResource.setProperty("SymlinkPropertyName", symlinkLocation);
            }
            if (properties != null && properties.length > 0) {
                for (String[] p : properties) {
                    metadataResource.setProperty(p[0], p[1]);
                }
            }
            metadataResource.setProperty("resource.source", "AdminConsole");
            String path = userRegistry.importResource(resourcePath, fetchURL, metadataResource);
            metadataResource.discard();
            return path;
        }
        catch (RegistryException e) {
            String msg = "Failed to import resource from the URL " + fetchURL + " to path " + resourcePath + ". " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

