/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.registry.common.eventing.NotificationService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.resource.download.DownloadManagerService;
import org.wso2.carbon.registry.resource.internal.ResourceDataHolder;
import org.wso2.carbon.registry.resource.services.utils.ContentUtil;
import org.wso2.carbon.registry.resource.servlets.ResourceServlet;

public class RegistryMgtUIResourceServiceComponent {
    private static Log log = LogFactory.getLog(RegistryMgtUIResourceServiceComponent.class);
    private ResourceDataHolder dataHolder = ResourceDataHolder.getInstance();
    private RegistryService registryService = null;
    private HttpService httpService = null;
    private ServiceRegistration serviceRegistration = null;

    protected void activate(ComponentContext context) {
        try {
            this.registerServlet(context.getBundleContext());
            log.debug((Object)"******* Registry Resources UI Management bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Failed to activate Registry Resources UI Management bundle ******* ", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Registry Resources UI Management bundle is deactivated ******* ");
    }

    public void registerServlet(BundleContext bundleContext) throws Exception {
        if (this.registryService == null) {
            String msg = "Unable to Register Servlet. Registry Service Not Found.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        Hashtable<String, String> servletParam = new Hashtable<String, String>(2);
        ((Dictionary)servletParam).put("org.apache.abdera.protocol.server.Provider", "org.wso2.carbon.registry.app.RegistryProvider");
        Hashtable<String, RegistryService> servletAttributes = new Hashtable<String, RegistryService>(2);
        ((Dictionary)servletAttributes).put("registry", this.registryService);
        Hashtable<String, Object> params = new Hashtable<String, Object>(2);
        ((Dictionary)params).put("servlet-params", servletParam);
        ((Dictionary)params).put("url-pattern", "/registry/resources");
        ((Dictionary)params).put("servlet-attributes", servletAttributes);
        ResourceServlet resourceServlet = new ResourceServlet();
        this.serviceRegistration = bundleContext.registerService(Servlet.class.getName(), (Object)resourceServlet, params);
    }

    protected void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
        this.dataHolder.setRegistryService(null);
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    protected void setRegistryNotificationService(NotificationService notificationService) {
        this.dataHolder.setRegistryNotificationService(notificationService);
    }

    protected void unsetRegistryNotificationService(NotificationService notificationService) {
        this.dataHolder.setRegistryNotificationService(null);
    }

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    protected void setDownloadManagerService(DownloadManagerService downloadManagerService) {
        ContentUtil.setDownloadManagerService(downloadManagerService);
    }

    protected void unsetDownloadManagerService(DownloadManagerService downloadManagerService) {
        ContentUtil.setDownloadManagerService(null);
    }
}

