/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.handler.listener;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.services.callback.LoginEvent;
import org.wso2.carbon.core.services.callback.LoginListener;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.handler.util.CommonUtil;

public class HandlerLoader
implements LoginListener {
    private static Log log = LogFactory.getLog(HandlerLoader.class);
    private List<Integer> initializedTenants = new LinkedList<Integer>();

    public void onLogin(Registry configSystemRegistry, LoginEvent loginEvent) {
        try {
            if (this.initializedTenants.contains(loginEvent.getTenantId())) {
                return;
            }
            this.initializedTenants.add(loginEvent.getTenantId());
            PrivilegedCarbonContext.startTenantFlow();
            try {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(loginEvent.getTenantDomain());
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(loginEvent.getTenantId());
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(loginEvent.getUsername());
                CommonUtil.addDefaultHandlersIfNotAvailable(configSystemRegistry);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        catch (Exception e) {
            String msg = "Error in adding the default handlers";
            log.error((Object)msg, (Throwable)e);
        }
    }
}

