/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.deployment.synchronizer.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.deployment.synchronizer.RegistryBasedArtifactRepository;
import org.wso2.carbon.registry.deployment.synchronizer.utils.RegistryServiceReferenceHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

public class RegistryDeploymentSynchronizerComponent {
    private static final Log log = LogFactory.getLog(RegistryDeploymentSynchronizerComponent.class);
    private ServiceRegistration registryDepSynServiceRegistration;

    protected void activate(ComponentContext context) {
        RegistryBasedArtifactRepository registryBasedArtifactRepository = new RegistryBasedArtifactRepository();
        this.registryDepSynServiceRegistration = context.getBundleContext().registerService(ArtifactRepository.class.getName(), (Object)registryBasedArtifactRepository, null);
    }

    protected void deactivate(ComponentContext context) {
        if (this.registryDepSynServiceRegistration != null) {
            this.registryDepSynServiceRegistration.unregister();
            this.registryDepSynServiceRegistration = null;
        }
        log.debug((Object)"Registry Deployment synchronizer component deactivated");
    }

    protected void setRegistryService(RegistryService service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deployment synchronizer component bound to the registry service");
        }
        RegistryServiceReferenceHolder.setRegistryService(service);
    }

    protected void unsetRegistryService(RegistryService service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deployment synchronizer component unbound from the registry service");
        }
        RegistryServiceReferenceHolder.setRegistryService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"carbon-registry deployment synchronizer component bound to the configuration context service");
        }
        RegistryServiceReferenceHolder.setConfigurationContextService(service);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"carbon-registry deployment synchronizer component unbound from the configuration context service");
        }
        RegistryServiceReferenceHolder.setEventingService(null);
    }
}

