/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.deployment.synchronizer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.util.RepositoryConfigParameter;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.deployment.synchronizer.RegistryUtils;
import org.wso2.carbon.registry.deployment.synchronizer.utils.RegistryServiceReferenceHolder;
import org.wso2.carbon.registry.synchronization.RegistrySynchronizer;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.Utils;

public class RegistryBasedArtifactRepository
implements ArtifactRepository {
    private static final Log log = LogFactory.getLog(RegistryBasedArtifactRepository.class);
    private UserRegistry registry;
    private String registryPath;
    private String basePath;
    private String subscriptionId;

    public RegistryBasedArtifactRepository() {
    }

    public RegistryBasedArtifactRepository(UserRegistry registry, String registryPath, String basePath) {
        this.registry = registry;
        this.registryPath = registryPath;
        this.basePath = basePath;
    }

    public void init(int tenantId) throws DeploymentSynchronizerException {
        try {
            UserRegistry configRegistry = RegistryBasedArtifactRepository.getConfigurationRegistry(tenantId);
            String tenantRegistryPath = RegistryBasedArtifactRepository.getRegistryPath(tenantId);
            this.registry = configRegistry;
            this.registryPath = tenantRegistryPath;
            this.basePath = "/_system/config";
            if (!configRegistry.resourceExists(tenantRegistryPath)) {
                Collection collection = configRegistry.newCollection();
                configRegistry.put(tenantRegistryPath, (Resource)collection);
                collection.discard();
            }
        }
        catch (RegistryException e) {
            throw new DeploymentSynchronizerException("Error while accessing registry for tenant: " + tenantId, (Throwable)e);
        }
    }

    private static UserRegistry getConfigurationRegistry(int tenantId) throws RegistryException {
        return RegistryServiceReferenceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
    }

    private static String getRegistryPath(int tenantId) {
        if (tenantId == -1234) {
            return "/repository/deployment/server";
        }
        return "/repository/deployment";
    }

    public boolean commit(int tenantId, String filePath) throws DeploymentSynchronizerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Committing artifacts at " + filePath + " to the collection at " + this.registryPath));
        }
        try {
            if (!RegistrySynchronizer.isCheckedOut((String)filePath)) {
                RegistrySynchronizer.checkOut((UserRegistry)this.registry, (String)filePath, (String)this.registryPath);
            }
            Utils.addResource((String)filePath);
            Utils.setResourcesDelete((String)filePath);
            return RegistrySynchronizer.checkIn((UserRegistry)this.registry, (String)filePath, (boolean)false);
        }
        catch (SynchronizationException e) {
            this.handleException("Error while committing artifacts to the registry", (Exception)((Object)e));
            return false;
        }
    }

    public boolean checkout(int tenantId, String filePath) throws DeploymentSynchronizerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking out artifacts from " + this.registryPath + " to the file system " + "at " + filePath));
        }
        boolean succeed = false;
        try {
            succeed = RegistrySynchronizer.isCheckedOut((String)filePath) ? RegistrySynchronizer.update((UserRegistry)this.registry, (String)filePath, (boolean)false) : RegistrySynchronizer.checkOut((UserRegistry)this.registry, (String)filePath, (String)this.registryPath);
        }
        catch (SynchronizationException e) {
            this.handleException("Error while updating artifacts in the file system from the registry", (Exception)((Object)e));
        }
        return succeed;
    }

    public void initAutoCheckout(boolean useEventing) throws DeploymentSynchronizerException {
        if (useEventing && this.subscriptionId == null && RegistryServiceReferenceHolder.getEventingService() != null) {
            String absolutePath = RegistryUtils.getAbsoluteRegistryPath(this.registryPath, this.basePath);
            this.subscriptionId = RegistryUtils.subscribeForRegistryEvents(this.registry, absolutePath, RegistryUtils.getEventReceiverEndpoint());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subscribed for registry events on the collection: " + absolutePath + " with the subscription ID: " + this.subscriptionId));
            }
        }
    }

    public void cleanupAutoCheckout() {
        if (this.subscriptionId == null) {
            return;
        }
        boolean unsubscribe = RegistryUtils.unsubscribeForRegistryEvents(this.subscriptionId, this.registry.getTenantId());
        if (!unsubscribe) {
            log.warn((Object)"Subscription for registry events could not be removed");
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Unsubscribed from registry events with the ID: " + this.subscriptionId));
        }
        this.subscriptionId = null;
    }

    public String getRepositoryType() {
        return "registry";
    }

    public List<RepositoryConfigParameter> getParameters() {
        return null;
    }

    public boolean checkout(int tenantId, String filePath, int depth) throws DeploymentSynchronizerException {
        throw new DeploymentSynchronizerException("Not implemented yet.");
    }

    public boolean update(int tenantId, String rootPath, String filePath, int depth) throws DeploymentSynchronizerException {
        throw new DeploymentSynchronizerException("Not implemented yet.");
    }

    public void cleanupTenantContext(int tenantId) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistryBasedArtifactRepository that = (RegistryBasedArtifactRepository)o;
        return this.getRepositoryType().equals(that.getRepositoryType());
    }

    public int hashCode() {
        return this.getRepositoryType().hashCode();
    }

    private void handleException(String msg, Exception e) throws DeploymentSynchronizerException {
        log.error((Object)msg, (Throwable)e);
        throw new DeploymentSynchronizerException(msg, (Throwable)e);
    }
}

