/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation;

import ca.uhn.hl7v2.AbstractHL7Exception;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Severity;

public class ValidationException
extends AbstractHL7Exception {
    public ValidationException() {
    }

    public ValidationException(String message, Throwable cause) {
        this(message, cause, Severity.ERROR);
    }

    public ValidationException(String message, Throwable cause, Severity severity) {
        super(message, cause);
        this.setSeverity(severity);
    }

    public ValidationException(Throwable cause) {
        this(cause, Severity.ERROR);
    }

    public ValidationException(Throwable cause, Severity severity) {
        super(cause);
        this.setSeverity(severity);
    }

    public ValidationException(String msg) {
        this(msg, Severity.ERROR);
    }

    public ValidationException(String msg, Severity severity) {
        super(msg);
        this.setSeverity(severity);
    }

    public static ValidationException fromHL7Exception(HL7Exception e) {
        ValidationException ve = new ValidationException(e.getMessageWithoutLocation(), e);
        ve.setErrorCode(e.getErrorCode());
        ve.setLocation(e.getLocation());
        ve.setSeverity(e.getSeverity());
        return ve;
    }
}

