/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util.idgenerator;

import ca.uhn.hl7v2.util.Home;
import ca.uhn.hl7v2.util.idgenerator.InMemoryIDGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedGenerator
extends InMemoryIDGenerator {
    private static final Logger LOG = LoggerFactory.getLogger((String)FileBasedGenerator.class.getName());
    private String directory = Home.getHomeDirectory().getAbsolutePath();
    private String fileName = "id_file";
    private boolean neverFail = true;
    private boolean used = false;
    private boolean minimizeReads = false;
    private ReentrantLock lock = new ReentrantLock();

    public FileBasedGenerator() {
        this(1);
    }

    FileBasedGenerator(int increment) {
        super(increment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getID() throws IOException {
        try {
            this.lock.lock();
            if (!this.minimizeReads || !this.used) {
                long readInitialValue = this.readInitialValue(this.getFilePath());
                if (readInitialValue >= 0L) {
                    this.set(readInitialValue);
                }
                this.used = true;
            }
            String id = super.getID();
            this.writeNextValue(Long.parseLong(id) + (long)this.getIncrement());
            String string = id;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeNextValue(long id) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(this.getFilePath(), false));
            pw.println(Long.toString(id));
        }
        catch (IOException e) {
            if (this.neverFail) {
                LOG.warn("Could not write ID to file {}, going to use internal ID generator. {}", (Object)this.getFilePath(), (Object)e.getMessage());
                return;
            }
            throw e;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readInitialValue(String path) throws IOException {
        BufferedReader br = null;
        String id = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            id = br.readLine();
            long l = Long.parseLong(id);
            return l;
        }
        catch (IOException e) {
            LOG.info("Could not read ID file {} ", (Object)path);
            if (!this.neverFail) {
                throw e;
            }
            long l = -1L;
            return l;
        }
        catch (NumberFormatException e) {
            LOG.info("ID {} read from file is not a number", id);
            long l = -1L;
            return l;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String getFilePath() {
        return new File(this.directory, this.fileName).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectory(String directory) {
        try {
            this.lock.lock();
            this.directory = directory;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileName(String fileName) {
        try {
            this.lock.lock();
            this.fileName = fileName;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMinimizeReads(boolean theMinimizeReads) {
        this.minimizeReads = theMinimizeReads;
    }

    public void setNeverFail(boolean neverFail) {
        this.neverFail = neverFail;
    }

    public void reset() {
        try {
            this.lock.lock();
            super.reset();
            this.writeNextValue(0L);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot initialize persistent ID generator", e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

