/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.TX;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OVR
extends AbstractSegment {
    public OVR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Business Rule Override Type");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Business Rule Override Code");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Override Comments");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Override Entered By");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Override Authorized By");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OVR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getBusinessRuleOverrideType() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getOvr1_BusinessRuleOverrideType() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getBusinessRuleOverrideCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getOvr2_BusinessRuleOverrideCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public TX getOverrideComments() {
        TX retVal = (TX)this.getTypedField(3, 0);
        return retVal;
    }

    public TX getOvr3_OverrideComments() {
        TX retVal = (TX)this.getTypedField(3, 0);
        return retVal;
    }

    public XCN getOverrideEnteredBy() {
        XCN retVal = (XCN)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN getOvr4_OverrideEnteredBy() {
        XCN retVal = (XCN)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN getOverrideAuthorizedBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public XCN getOvr5_OverrideAuthorizedBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new TX(this.getMessage());
            }
            case 3: {
                return new XCN(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
        }
        return null;
    }
}

