/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CNE;
import ca.uhn.hl7v2.model.v251.datatype.MO;

public class UVC
extends AbstractComposite {
    private Type[] data;

    public UVC(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new CNE(this.getMessage());
        this.data[1] = new MO(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CNE getValueCode() {
        return this.getTyped(0, CNE.class);
    }

    public CNE getUvc1_ValueCode() {
        return this.getTyped(0, CNE.class);
    }

    public MO getValueAmount() {
        return this.getTyped(1, MO.class);
    }

    public MO getUvc2_ValueAmount() {
        return this.getTyped(1, MO.class);
    }
}

