/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CP;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class GP1
extends AbstractSegment {
    public GP1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IS.class, true, 1, 3, new Object[]{this.getMessage(), new Integer(455)}, "Type of Bill Code");
            this.add(IS.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(456)}, "Revenue Code");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(457)}, "Overall Claim Disposition Code");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(458)}, "OCE Edits per Visit Code");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Outlier Cost");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating GP1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public IS getTypeOfBillCode() {
        IS retVal = (IS)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getGp11_TypeOfBillCode() {
        IS retVal = (IS)this.getTypedField(1, 0);
        return retVal;
    }

    public IS[] getRevenueCode() {
        IS[] retVal = (IS[])this.getTypedField(2, new IS[0]);
        return retVal;
    }

    public IS[] getGp12_RevenueCode() {
        IS[] retVal = (IS[])this.getTypedField(2, new IS[0]);
        return retVal;
    }

    public int getRevenueCodeReps() {
        return this.getReps(2);
    }

    public IS getRevenueCode(int rep) {
        IS retVal = (IS)this.getTypedField(2, rep);
        return retVal;
    }

    public IS getGp12_RevenueCode(int rep) {
        IS retVal = (IS)this.getTypedField(2, rep);
        return retVal;
    }

    public int getGp12_RevenueCodeReps() {
        return this.getReps(2);
    }

    public IS insertRevenueCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(2, rep);
    }

    public IS insertGp12_RevenueCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(2, rep);
    }

    public IS removeRevenueCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(2, rep);
    }

    public IS removeGp12_RevenueCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(2, rep);
    }

    public IS getOverallClaimDispositionCode() {
        IS retVal = (IS)this.getTypedField(3, 0);
        return retVal;
    }

    public IS getGp13_OverallClaimDispositionCode() {
        IS retVal = (IS)this.getTypedField(3, 0);
        return retVal;
    }

    public IS[] getOCEEditsPerVisitCode() {
        IS[] retVal = (IS[])this.getTypedField(4, new IS[0]);
        return retVal;
    }

    public IS[] getGp14_OCEEditsPerVisitCode() {
        IS[] retVal = (IS[])this.getTypedField(4, new IS[0]);
        return retVal;
    }

    public int getOCEEditsPerVisitCodeReps() {
        return this.getReps(4);
    }

    public IS getOCEEditsPerVisitCode(int rep) {
        IS retVal = (IS)this.getTypedField(4, rep);
        return retVal;
    }

    public IS getGp14_OCEEditsPerVisitCode(int rep) {
        IS retVal = (IS)this.getTypedField(4, rep);
        return retVal;
    }

    public int getGp14_OCEEditsPerVisitCodeReps() {
        return this.getReps(4);
    }

    public IS insertOCEEditsPerVisitCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(4, rep);
    }

    public IS insertGp14_OCEEditsPerVisitCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(4, rep);
    }

    public IS removeOCEEditsPerVisitCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(4, rep);
    }

    public IS removeGp14_OCEEditsPerVisitCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(4, rep);
    }

    public CP getOutlierCost() {
        CP retVal = (CP)this.getTypedField(5, 0);
        return retVal;
    }

    public CP getGp15_OutlierCost() {
        CP retVal = (CP)this.getTypedField(5, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new IS(this.getMessage(), new Integer(455));
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(456));
            }
            case 2: {
                return new IS(this.getMessage(), new Integer(457));
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(458));
            }
            case 4: {
                return new CP(this.getMessage());
            }
        }
        return null;
    }
}

