/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.RDR_RDR_DISPENSE;
import ca.uhn.hl7v2.model.v25.group.RDR_RDR_ENCODING;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDR_RDR_ORDER
extends AbstractGroup {
    public RDR_RDR_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RDR_RDR_ENCODING.class, false, false, false);
            this.add(RDR_RDR_DISPENSE.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RDR_RDR_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RDR_RDR_ENCODING getENCODING() {
        RDR_RDR_ENCODING retVal = this.getTyped("ENCODING", RDR_RDR_ENCODING.class);
        return retVal;
    }

    public RDR_RDR_DISPENSE getDISPENSE() {
        RDR_RDR_DISPENSE retVal = this.getTyped("DISPENSE", RDR_RDR_DISPENSE.class);
        return retVal;
    }

    public RDR_RDR_DISPENSE getDISPENSE(int rep) {
        RDR_RDR_DISPENSE retVal = this.getTyped("DISPENSE", rep, RDR_RDR_DISPENSE.class);
        return retVal;
    }

    public int getDISPENSEReps() {
        return this.getReps("DISPENSE");
    }

    public List<RDR_RDR_DISPENSE> getDISPENSEAll() throws HL7Exception {
        return this.getAllAsList("DISPENSE", RDR_RDR_DISPENSE.class);
    }

    public void insertDISPENSE(RDR_RDR_DISPENSE structure, int rep) throws HL7Exception {
        super.insertRepetition("DISPENSE", structure, rep);
    }

    public RDR_RDR_DISPENSE insertDISPENSE(int rep) throws HL7Exception {
        return (RDR_RDR_DISPENSE)super.insertRepetition("DISPENSE", rep);
    }

    public RDR_RDR_DISPENSE removeDISPENSE(int rep) throws HL7Exception {
        return (RDR_RDR_DISPENSE)super.removeRepetition("DISPENSE", rep);
    }
}

