/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_PIP;
import ca.uhn.hl7v2.model.v23.datatype.CM_PLN;
import ca.uhn.hl7v2.model.v23.datatype.CM_SPD;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRA
extends AbstractSegment {
    public PRA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "PRA - Primary Key Value");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Practioner Group");
            this.add(ID.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(0)}, "Practioner Category");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(186)}, "Provider Billing");
            this.add(CM_SPD.class, false, 0, 100, new Object[]{this.getMessage()}, "Specialty");
            this.add(CM_PLN.class, false, 0, 100, new Object[]{this.getMessage()}, "Practitioner ID Numbers");
            this.add(CM_PIP.class, false, 0, 200, new Object[]{this.getMessage()}, "Privileges");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PRA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getPRAPrimaryKeyValue() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getPra1_PRAPrimaryKeyValue() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public CE[] getPractionerGroup() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public CE[] getPra2_PractionerGroup() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public int getPractionerGroupReps() {
        return this.getReps(2);
    }

    public CE getPractionerGroup(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getPra2_PractionerGroup(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPra2_PractionerGroupReps() {
        return this.getReps(2);
    }

    public CE insertPractionerGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertPra2_PractionerGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removePractionerGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removePra2_PractionerGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public ID[] getPractionerCategory() {
        ID[] retVal = (ID[])this.getTypedField(3, new ID[0]);
        return retVal;
    }

    public ID[] getPra3_PractionerCategory() {
        ID[] retVal = (ID[])this.getTypedField(3, new ID[0]);
        return retVal;
    }

    public int getPractionerCategoryReps() {
        return this.getReps(3);
    }

    public ID getPractionerCategory(int rep) {
        ID retVal = (ID)this.getTypedField(3, rep);
        return retVal;
    }

    public ID getPra3_PractionerCategory(int rep) {
        ID retVal = (ID)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPra3_PractionerCategoryReps() {
        return this.getReps(3);
    }

    public ID insertPractionerCategory(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID insertPra3_PractionerCategory(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID removePractionerCategory(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID removePra3_PractionerCategory(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID getProviderBilling() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getPra4_ProviderBilling() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CM_SPD[] getSpecialty() {
        CM_SPD[] retVal = (CM_SPD[])this.getTypedField(5, new CM_SPD[0]);
        return retVal;
    }

    public CM_SPD[] getPra5_Specialty() {
        CM_SPD[] retVal = (CM_SPD[])this.getTypedField(5, new CM_SPD[0]);
        return retVal;
    }

    public int getSpecialtyReps() {
        return this.getReps(5);
    }

    public CM_SPD getSpecialty(int rep) {
        CM_SPD retVal = (CM_SPD)this.getTypedField(5, rep);
        return retVal;
    }

    public CM_SPD getPra5_Specialty(int rep) {
        CM_SPD retVal = (CM_SPD)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPra5_SpecialtyReps() {
        return this.getReps(5);
    }

    public CM_SPD insertSpecialty(int rep) throws HL7Exception {
        return (CM_SPD)super.insertRepetition(5, rep);
    }

    public CM_SPD insertPra5_Specialty(int rep) throws HL7Exception {
        return (CM_SPD)super.insertRepetition(5, rep);
    }

    public CM_SPD removeSpecialty(int rep) throws HL7Exception {
        return (CM_SPD)super.removeRepetition(5, rep);
    }

    public CM_SPD removePra5_Specialty(int rep) throws HL7Exception {
        return (CM_SPD)super.removeRepetition(5, rep);
    }

    public CM_PLN[] getPractitionerIDNumbers() {
        CM_PLN[] retVal = (CM_PLN[])this.getTypedField(6, new CM_PLN[0]);
        return retVal;
    }

    public CM_PLN[] getPra6_PractitionerIDNumbers() {
        CM_PLN[] retVal = (CM_PLN[])this.getTypedField(6, new CM_PLN[0]);
        return retVal;
    }

    public int getPractitionerIDNumbersReps() {
        return this.getReps(6);
    }

    public CM_PLN getPractitionerIDNumbers(int rep) {
        CM_PLN retVal = (CM_PLN)this.getTypedField(6, rep);
        return retVal;
    }

    public CM_PLN getPra6_PractitionerIDNumbers(int rep) {
        CM_PLN retVal = (CM_PLN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getPra6_PractitionerIDNumbersReps() {
        return this.getReps(6);
    }

    public CM_PLN insertPractitionerIDNumbers(int rep) throws HL7Exception {
        return (CM_PLN)super.insertRepetition(6, rep);
    }

    public CM_PLN insertPra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (CM_PLN)super.insertRepetition(6, rep);
    }

    public CM_PLN removePractitionerIDNumbers(int rep) throws HL7Exception {
        return (CM_PLN)super.removeRepetition(6, rep);
    }

    public CM_PLN removePra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (CM_PLN)super.removeRepetition(6, rep);
    }

    public CM_PIP[] getPrivileges() {
        CM_PIP[] retVal = (CM_PIP[])this.getTypedField(7, new CM_PIP[0]);
        return retVal;
    }

    public CM_PIP[] getPra7_Privileges() {
        CM_PIP[] retVal = (CM_PIP[])this.getTypedField(7, new CM_PIP[0]);
        return retVal;
    }

    public int getPrivilegesReps() {
        return this.getReps(7);
    }

    public CM_PIP getPrivileges(int rep) {
        CM_PIP retVal = (CM_PIP)this.getTypedField(7, rep);
        return retVal;
    }

    public CM_PIP getPra7_Privileges(int rep) {
        CM_PIP retVal = (CM_PIP)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPra7_PrivilegesReps() {
        return this.getReps(7);
    }

    public CM_PIP insertPrivileges(int rep) throws HL7Exception {
        return (CM_PIP)super.insertRepetition(7, rep);
    }

    public CM_PIP insertPra7_Privileges(int rep) throws HL7Exception {
        return (CM_PIP)super.insertRepetition(7, rep);
    }

    public CM_PIP removePrivileges(int rep) throws HL7Exception {
        return (CM_PIP)super.removeRepetition(7, rep);
    }

    public CM_PIP removePra7_Privileges(int rep) throws HL7Exception {
        return (CM_PIP)super.removeRepetition(7, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(186));
            }
            case 4: {
                return new CM_SPD(this.getMessage());
            }
            case 5: {
                return new CM_PLN(this.getMessage());
            }
            case 6: {
                return new CM_PIP(this.getMessage());
            }
        }
        return null;
    }
}

